@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.content-update', 'auth') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::CONTENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-8">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Content Update', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[login_title]',
                                        'label' => 'Login Title',
                                        'value' => cms('auth', 'login_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[register_title]',
                                        'label' => 'Login Title',
                                        'value' => cms('auth', 'register_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[code_verify_title]',
                                        'label' => 'Code Verify Title',
                                        'value' => cms('auth', 'code_verify_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[password_reset_title]',
                                        'label' => 'Password Reset Title',
                                        'value' => cms('auth', 'password_reset_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ]
                                ]) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Image Section', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <input type="hidden" name="images" value="image">

                            <?= builder([
                                    [
                                        'type' => 'image',
                                        'name' => 'content[image]',
                                        'label' => 'Image',
                                        'value' => cms('auth', 'image'),
                                        'size' => '400x400',
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>


            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
