@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.content-update', 'banner') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::CONTENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-8">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Content Update', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[banner_top_title]',
                                        'label' => 'Banner Top Title',
                                        'value' => cms('banner', 'banner_top_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[banner_title]',
                                        'label' => 'Banner Title',
                                        'value' => cms('banner', 'banner_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[calculator_title]',
                                        'label' => 'Calculator Title',
                                        'value' => cms('banner', 'calculator_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'textarea',
                                        'name' => 'content[banner_details]',
                                        'label' => 'Banner Details',
                                        'value' => cms('banner', 'banner_details'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                ]) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Banner Image', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <input type="hidden" name="images" value="image">
                            <?= builder([
                                    [
                                        'type' => 'image',
                                        'name' => 'content[element]',
                                        'label' => 'Element Image',
                                        'value' => cms('banner', 'element', trans: false),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'size' => '620x565',
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'image',
                                        'name' => 'content[background_image]',
                                        'label' => 'Background Image',
                                        'value' => cms('banner', 'background_image', trans: false),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'size' => '620x565',
                                        'input_attributes' => [],
                                    ],
                                ]) ?>

                        </div>
                    </div>
                </div>
            </div>



            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection



@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
@endpush
