@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.content-update', 'blog') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::CONTENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Content Update', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[top_title]',
                                        'label' => 'Top Title',
                                        'value' => cms('blog', 'top_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],

                                    [
                                        'type' => 'text',
                                        'name' => 'content[title]',
                                        'label' => 'Title',
                                        'value' => cms('blog', 'title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ]
                                ]) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
