@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.content-update', 'contact') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::CONTENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Content Update', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[top_title]',
                                        'label' => 'Top Title',
                                        'value' => cms('contact', 'top_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[title]',
                                        'label' => 'Title',
                                        'value' => cms('contact', 'title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[heading]',
                                        'label' => 'Heading',
                                        'value' => cms('contact', 'heading'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],

                                    [
                                        'type' => 'text',
                                        'name' => 'content[address]',
                                        'label' => 'Address',
                                        'value' => cms('contact', 'address'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],

                                    [
                                        'type' => 'text',
                                        'name' => 'content[phone]',
                                        'label' => 'Phone',
                                        'value' => cms('contact', 'phone'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],

                                    [
                                        'type' => 'text',
                                        'name' => 'content[email]',
                                        'label' => 'Email',
                                        'value' => cms('contact', 'email'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[map_link]',
                                        'label' => 'Map Link',
                                        'value' => cms('contact', 'map_link'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'textarea',
                                        'name' => 'content[details]',
                                        'label' => 'Details',
                                        'value' => cms('contact', 'details'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'ai_enabled' => true,
                                        'input_attributes' => [],
                                    ],
                                ]) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
