@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.content-update', 'faq') }}" enctype="multipart/form-data">
        @csrf
        <input type="hidden" value="{{ cons()::CONTENT }}" name="type">
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card h-100">
                    <div class="card-header">
                        <h4 class="card-title mb-0">{{ tt_trans('Content Update', cons()::LANGUAGE_BACKEND) }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row gy-3">
                            <?= builder([
                                    [
                                        'type' => 'text',
                                        'name' => 'content[top_title]',
                                        'label' => 'Top Title',
                                        'value' => cms('faq', 'top_title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[title]',
                                        'label' => 'Title',
                                        'value' => cms('faq', 'title'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[button_name]',
                                        'label' => 'Button Name',
                                        'value' => cms('faq', 'button_name'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'text',
                                        'name' => 'content[button_link]',
                                        'label' => 'Button Link',
                                        'value' => cms('faq', 'button_link'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-6',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                    [
                                        'type' => 'textarea',
                                        'name' => 'content[details]',
                                        'label' => 'Short Description',
                                        'value' => cms('faq', 'details'),
                                        'parent_attributes' => [
                                            'class' => 'col-md-12',
                                        ],
                                        'input_attributes' => [],
                                    ],
                                ]) ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <button type="submit"
                    class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </div>
    </form>

    <div class="card mt-4">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans(ucwords(request()->section) . ' Manager', cons()::LANGUAGE_BACKEND) }}
            </h4>
            <a href="{{ route('panel.content-create', 'faq') }}" class="btn btn-sm btn-primary"><i class="ri-add-line"></i>
                {{ tt_trans('Add Item', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
        <div class="card-body">

            <x-table>
                <tr>
                    <th scope="col"><i
                            class="ri-account-circle-line"></i>{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i
                            class="ri-arrow-right-up-line"></i>{{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse (cms('faq','',cons()::ELEMENT) as $element)
                        <tr>
                            <td>
                                {{ $element->content->title }}
                            </td>

                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="{{ route('panel.element-edit', $element->id) }}"
                                        class="btn btn-icon btn-primary">
                                        <i class="ri-edit-line"></i>
                                    </a>
                                    <x-delete-button
                                        action="{{ route('panel.element-delete', $element->id) }}"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty
                    @endforelse
                </x-slot>

            </x-table>
        </div>
    </div>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
