@extends('backend.layouts.master')

@section('panel')
    <div class="card mt-4">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans(ucwords(request()->section) . ' Manager', cons()::LANGUAGE_BACKEND) }}
            </h4>
            <a href="{{ route('panel.content-create', 'social') }}" class="btn btn-sm btn-primary"><i class="ri-add-line"></i>
                {{ tt_trans('Add Item', cons()::LANGUAGE_BACKEND) }}</a>
        </div>
        <div class="card-body">

            <x-table>
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>{{ tt_trans('Icon', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-account-circle-line"></i>{{ tt_trans('Link', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i
                            class="ri-arrow-right-up-line"></i>{{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse (cms('social','',cons()::ELEMENT) as $element)
                        <tr>
                            <td>
                                <?= $element->content->icon ?>
                            </td>
                            <td>
                                <?= $element->content->link ?>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="{{ route('panel.element-edit', $element->id) }}"
                                        class="btn btn-icon btn-primary">
                                        <i class="ri-edit-line"></i>
                                    </a>
                                    <x-delete-button
                                        action="{{ route('panel.element-delete', $element->id) }}"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty
                    @endforelse
                </x-slot>

            </x-table>
        </div>
    </div>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('iconpicker.min.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
    <script src="{{ js('iconpicker.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.iconPicker').iconpicker({
                placement: 'bottomRight'
            });
        })
    </script>
@endpush
