@extends('backend.layouts.master')

@section('panel')
    <div class="card border px-3">
        <ul class="nav nav-tabs bordered-tab border-0 nav-tabs-gap-0 gap-xl-3" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link gap-1 {{ activeTab('general') }}" id="tab-1-tab" data-bs-toggle="tab"
                    data-bs-target="#tab-1-tab-pane" type="button" role="tab" aria-controls="tab-1-tab-pane"
                    aria-selected="true">
                    <span class="text-lg"><iconify-icon icon="tabler:settings-cog"></iconify-icon></span>
                    <span>{{ tt_trans('General Settings', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button class="nav-link gap-1 {{ activeTab('plugin') }}" id="tab-2-tab" data-bs-toggle="tab"
                    data-bs-target="#tab-2-tab-pane" type="button" role="tab" aria-controls="tab-2-tab-pane"
                    aria-selected="false">
                    <span class="text-lg"><iconify-icon icon="ant-design:api-outlined"></iconify-icon></span>
                    <span>{{ tt_trans('Plugin Settings', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link gap-1 {{ activeTab('kyc') }}" id="tab-3-tab" data-bs-toggle="tab"
                    data-bs-target="#tab-3-tab-pane" type="button" role="tab" aria-controls="tab-3-tab-pane"
                    aria-selected="false">
                    <span class="text-lg"><iconify-icon icon="hugeicons:id-verified"></iconify-icon></span>
                    <span>{{ tt_trans('Kyc Settings', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button class="nav-link gap-1 {{ activeTab('maintanance') }}" id="tab-3-tab" data-bs-toggle="tab"
                    data-bs-target="#maintanance" type="button" role="tab" aria-controls="tab-3-tab-pane"
                    aria-selected="false">
                    <span class="text-lg"><iconify-icon icon="hugeicons:id-verified"></iconify-icon></span>
                    <span>{{ tt_trans('Maintenance Settings', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </li>



            <li class="nav-item" role="presentation">
                <button class="nav-link gap-1 {{ activeTab('cron') }}" id="tab-4-tab" data-bs-toggle="tab"
                    data-bs-target="#tab-4-tab-pane" type="button" role="tab" aria-controls="tab-4-tab-pane"
                    aria-selected="false">
                    <span class="text-lg"><iconify-icon icon="hugeicons:cpu-settings"></iconify-icon></span>
                    <span>{{ tt_trans('Cronjob & Other Settings', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </li>
        </ul>
    </div>

    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade {{ activeTab('general', true) }}" id="tab-1-tab-pane" role="tabpanel"
            aria-labelledby="tab-1-tab" tabindex="0">
            <form  method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="tab" value="general">
                <div class="row gy-4">
                    <div class="col-xxl-3 col-lg-4">
                        <div class="card h-100">
                            <div class="card-header">
                                <h4 class="card-title mb-0">{{ tt_trans('Admin Background', cons()::LANGUAGE_BACKEND) }}
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row gy-3">

                                    <x-image-upload title="Admin Background" parent="col-md-12" id="single-3"
                                        :image="getFile('background', tc()->get('background'), '1905x925')" name="background"></x-image-upload>


                                </div>

                                <hr class="my-4">

                                <h6 class="mb-4 mt-3">{{ tt_trans('Preference', cons()::LANGUAGE_BACKEND) }}</h6>

                                <div class="row g-3">
                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('Email verification on', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="email_ver"
                                            {{ tc()->get('email_ver') ? 'checked' : '' }} type="checkbox"
                                            data-on="{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}"
                                            data-off="Deactive" data-onstyle="success" data-offstyle="danger"
                                            data-width="100%">
                                    </div>
                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('Sms verification on', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="sms_ver"
                                            {{ tc()->get('sms_ver') ? 'checked' : '' }} type="checkbox"
                                            data-on="{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}"
                                            data-off="{{ tt_trans('Deactive', cons()::LANGUAGE_BACKEND) }}"
                                            data-onstyle="success" data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('User registration', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="user_reg"
                                            {{ tc()->get('user_reg') ? 'checked' : '' }} type="checkbox"
                                            data-on="{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}"
                                            data-off="{{ tt_trans('Deactive', cons()::LANGUAGE_BACKEND) }}"
                                            data-onstyle="success" data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('User kyc verification', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="kyc_ver"
                                            {{ tc()->get('kyc_ver') ? 'checked' : '' }} type="checkbox"
                                            data-on="{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}"
                                            data-off="{{ tt_trans('Deactive', cons()::LANGUAGE_BACKEND) }}"
                                            data-onstyle="success" data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('Allow preloader', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="preloader"
                                            {{ tc()->get('preloader') ? 'checked' : '' }} type="checkbox"
                                            data-on="{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}"
                                            data-off="{{ tt_trans('Deactive', cons()::LANGUAGE_BACKEND) }}"
                                            data-onstyle="success" data-offstyle="danger" data-width="100%">
                                    </div>


                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('Maintenance Mode', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="maintanance_mode"
                                            {{ tc()->get('maintanance_mode') ? 'checked' : '' }} type="checkbox"
                                            data-on="On" data-off="Off" data-onstyle="success" data-offstyle="danger"
                                            data-width="100%">
                                    </div>


                                    <div class="col-xxl-6 col-lg-12 col-sm-6">
                                        <p class="mb-0 text-sm text-muted">
                                            {{ tt_trans('Strong Password', cons()::LANGUAGE_BACKEND) }}:</p>
                                        <input class="toggle-one" name="strong_password"
                                            {{ tc()->get('strong_password') ? 'checked' : '' }} type="checkbox"
                                            data-on="On" data-off="Off" data-onstyle="success" data-offstyle="danger"
                                            data-width="100%">
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-9 col-lg-8">
                        <div class="card h-100">
                            <div class="card-header">
                                <h4 class="card-title mb-0">
                                    {{ tt_trans('Site Configurations', cons()::LANGUAGE_BACKEND) }}
                                </h4>
                            </div>

                            <div class="card-body">
                                <div class="row gy-3">
                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Site name', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="sitename" class="form-control"
                                            placeholder="Enter Site Name" value="{{ tc()->get('sitename') }}">
                                    </div>
                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Site currency', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="currency" class="form-control"
                                            placeholder="Enter Currency" value="{{ tc()->get('currency') }}">
                                    </div>
                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Decimal precision', cons()::LANGUAGE_BACKEND) }}</label>
                                        <div class="input-group">
                                            <input type="number" step="any" name="precision" class="form-control"
                                                placeholder="Enter {{ tt_trans('Decimal Precision', cons()::LANGUAGE_BACKEND) }}"
                                                value="{{ tc()->get('precision') }}">
                                            <span
                                                class="input-group-text text-sm">{{ tt_trans('Decimal precision', cons()::LANGUAGE_BACKEND) }}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Sign up bonus', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="number" step="any" name="signup_bonus" class="form-control"
                                            placeholder="Enter {{ tt_trans('Sign Up Bonus', cons()::LANGUAGE_BACKEND) }}"
                                            value="{{ formatter(tc()->get('signup_bonus')) }}">
                                    </div>
                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Withdraw limit', cons()::LANGUAGE_BACKEND) }}</label>
                                        <div class="input-group">
                                            <input type="number" name="withdraw_limit" class="form-control"
                                                placeholder="Enter {{ tt_trans('Withdraw Limit', cons()::LANGUAGE_BACKEND) }}"
                                                value="{{ number_format(tc()->get('withdraw_limit'), 0) }}">
                                            <span
                                                class="input-group-text text-sm">{{ tt_trans('Times per day', cons()::LANGUAGE_BACKEND) }}</span>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Pagination limit', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="number" name="pagination" class="form-control"
                                            placeholder="Enter Pagination limit" value="{{ tc()->get('pagination') }}">
                                    </div>

                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Timezone', cons()::LANGUAGE_BACKEND) }}</label>

                                        <select class="form-select form-select-two" name="timezone">
                                            @foreach ($zones as $region => $list)
                                                @foreach ($list as $timezone => $name)
                                                    <option value="{{ $timezone }}"
                                                        {{ tc()->get('timezone') == $timezone ? 'selected' : '' }}>
                                                        {{ $name }}</option>
                                                @endforeach
                                            @endforeach

                                        </select>
                                    </div>


                                    <div class="col-lg-6">
                                        <label
                                            class="form-label">{{ tt_trans('Default Language', cons()::LANGUAGE_BACKEND) }}</label>

                                        <select class="form-select" name="default_language">
                                            <option value="en" @selected(tc()->get('default_language') == 'en')>
                                                {{ tt_trans('English', cons()::LANGUAGE_BACKEND) }}</option>

                                            @foreach (languages() as $language)
                                                <option value="{{ $language->code }}" @selected(tc()->get('default_language') == $language->code)>
                                                    {{ $language->name }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                    <div class="col-lg-12">
                                        <label
                                            class="form-label">{{ tt_trans('Copyright text', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="copyright" class="form-control"
                                            placeholder="Enter Copyright" value="{{ tc()->get('copyright') }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-end mt-4">
                    <button class="btn btn-primary">{{ tt_trans('Update Settings', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </form>
        </div>
        <div class="tab-pane fade {{ activeTab('plugin', true) }}" id="tab-2-tab-pane" role="tabpanel"
            aria-labelledby="tab-2-tab" tabindex="0">
            <div class="row gy-4">
                <div class="col-xxl-4 col-md-6 order-xxl-0 order-1">
                    <div class="card p-3 h-100">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-white text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="logos:recaptcha"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('GOOGLE RECAPTCHA V3', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://developers.google.com/recaptcha/docs/v3" target="_blank"
                                class="ms-auto text-primary text-xxl" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Google Recaptcha', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf

                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="recaptcha">

                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Recaptcha key', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="recaptcha_app_key" class="form-control"
                                        placeholder="Enter Api ID" value="{{ tc()->get('recaptcha_app_key') }}">
                                </div>
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Recaptcha secret', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="recaptcha_app_secret" class="form-control"
                                        placeholder="Enter app secret" value="{{ tc()->get('recaptcha_app_secret') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label
                                            class="form-label">{{ tt_trans('Recaptcha status', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input class="toggle-one" name="recaptcha_status"
                                            {{ tc()->get('recaptcha_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6 order-xxl-0 order-2">
                    <div class="card p-3 h-100">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-warning text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="simple-icons:pusher"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('PUSHER FOR NOTIFICATION', cons()::LANGUAGE_BACKEND) }}
                            </h4>
                            <a href="https://pusher.com/" target="_blank" class="ms-auto text-primary text-xxl"
                                data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Pusher Notification Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="pusher">
                                <div class="row gy-2">
                                    <div class="col-sm-6">
                                        <label
                                            class="form-label">{{ tt_trans('App Key', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="pusher_app_key" class="form-control"
                                            placeholder="Enter app key" value="{{ tc()->get('pusher_app_key') }}">
                                    </div>

                                    <div class="col-sm-6">
                                        <label
                                            class="form-label">{{ tt_trans('App Secret', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="pusher_app_secret" class="form-control"
                                            placeholder="Enter app secret" value="{{ tc()->get('pusher_app_secret') }}">
                                    </div>
                                    <div class="col-sm-6">
                                        <label
                                            class="form-label">{{ tt_trans('App Id', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="pusher_app_id" class="form-control"
                                            placeholder="Enter app id" value="{{ tc()->get('pusher_app_id') }}">
                                    </div>

                                    <div class="col-sm-6">
                                        <label
                                            class="form-label">{{ tt_trans('App cluster ', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="pusher_app_cluster" class="form-control"
                                            placeholder="Enter app cluster "
                                            value="{{ tc()->get('pusher_app_cluster') }}">
                                    </div>
                                </div>

                                <div class="row row-cols-2 align-items-end mt-2">
                                    <div class="col">
                                        <label class="form-label">{{ tt_trans('App status') }}</label>
                                        <input class="toggle-one" name="pusher_status"
                                            {{ tc()->get('pusher_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-info text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="fa-solid:sms"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('Infobip (FOR SMS)', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://www.infobip.com/" target="_blank" class="ms-auto text-primary text-xxl"
                                data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Infobip Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf

                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="infobip">

                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Username', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="infobip_username" class="form-control"
                                        placeholder="Enter username" value="{{ tc()->get('infobip_username') }}">
                                </div>
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Password', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="infobip_password" class="form-control"
                                        placeholder="Enter password" value="{{ tc()->get('infobip_password') }}">
                                </div>


                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Sender Number', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="infobip_sender_number" class="form-control"
                                        placeholder="Enter sender number"
                                        value="{{ tc()->get('infobip_sender_number') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label
                                            class="form-label">{{ tt_trans('App Status', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input class="toggle-one" name="infobip_status"
                                            {{ tc()->get('infobip_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-primary text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="mdi:facebook"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('FACEBOOK AUTH', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://developers.facebook.com/" target="_blank"
                                class="ms-auto text-primary text-xxl" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Facebook Auth Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="facebook">
                                <div class="mb-2">
                                    <label class="form-label">{{ tt_trans('App id', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="facebook_app_id" class="form-control"
                                        placeholder="Enter App ID" value="{{ tc()->get('facebook_app_id') }}">
                                </div>
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('App secret', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="facebook_app_secret" class="form-control"
                                        placeholder="Enter Secret" value="{{ tc()->get('facebook_app_secret') }}">
                                </div>

                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Callback url', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="facebook_callback" class="form-control" readonly disabled
                                        placeholder="Enter Secret" value="{{request()->root().'/'. tc()->get('facebook_callback') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label class="form-label">{{ tt_trans('App Status') }}</label>
                                        <input class="toggle-one" name="facebook_status"
                                            {{ tc()->get('facebook_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-red text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="ri:google-fill"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('GOOGLE AUTH', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://console.cloud.google.com/" target="_blank"
                                class="ms-auto text-primary text-xxl" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Google Auth Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="google">
                                <div class="mb-2">
                                    <label class="form-label">{{ tt_trans('App id', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="google_app_id" class="form-control"
                                        placeholder="Enter app ID" value="{{ tc()->get('google_app_id') }}">
                                </div>
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('App secret', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="google_app_secret" class="form-control"
                                        placeholder="Enter app secret" value="{{ tc()->get('google_app_secret') }}">
                                </div>

                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Callback url', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="google_callback" class="form-control" readonly disabled
                                        placeholder="Enter Secret" value="{{ request()->root().'/'.tc()->get('google_callback') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label class="form-label">{{ tt_trans('App Status') }}</label>
                                        <input class="toggle-one" name="google_status"
                                            {{ tc()->get('google_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3 h-100">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-cyan text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="heroicons:chat-bubble-left-right-solid"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('TIDIO SETTINGS', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://www.tidio.com/" target="_blank" class="ms-auto text-primary text-xxl"
                                data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Tidio Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">

                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="tdio">
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Tidio url', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="tdio_url" class="form-control"
                                        placeholder="Enter tdio url" value="{{ tc()->get('tdio_url') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label
                                            class="form-label">{{ tt_trans('App Status', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input class="toggle-one" name="tdio_status"
                                            {{ tc()->get('tdio_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3 h-100">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-warning text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="simple-icons:googleanalytics"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('GOOGLE ANALYTICS', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://marketingplatform.google.com/about/analytics/" target="_blank"
                                class="ms-auto text-primary text-xxl" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Google Analytics Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="analytics">
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Analytics id', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="analytics_id" class="form-control"
                                        placeholder="Enter Api ID" value="{{ tc()->get('analytics_id') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label class="form-label">{{ tt_trans('App status') }}</label>
                                        <input class="toggle-one" name="analytics_status"
                                            {{ tc()->get('analytics_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



                <div class="col-xxl-4 col-md-6">
                    <div class="card p-3 h-100">
                        <div class="p-2 d-flex flex-wrap align-items-center gap-3 bg-light rounded-2">
                            <div class="card-icon-lg bg-warning text-white text-2xxl rounded-2 item-center">
                                <iconify-icon icon="logos:openai-icon"></iconify-icon>
                            </div>
                            <h4 class="mb-0 text-md">{{ tt_trans('Open AI', cons()::LANGUAGE_BACKEND) }}</h4>
                            <a href="https://openai.com/" target="_blank"
                                class="ms-auto text-primary text-xxl" data-bs-toggle="tooltip" data-bs-placement="top"
                                data-bs-title="{{ tt_trans('Open AI Site', cons()::LANGUAGE_BACKEND) }}"><i
                                    class="bi bi-link-45deg"></i></a>
                        </div>
                        <div class="p-2">
                            <form action="{{ route('panel.plugin-update') }}" method="post">
                                @csrf
                                <input type="hidden" name="tab" value="plugin">
                                <input type="hidden" name="type" value="ai">
                                <div class="mb-2">
                                    <label
                                        class="form-label">{{ tt_trans('Open Ai Key', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="ai_key" class="form-control"
                                        placeholder="Enter open ai key" value="{{ tc()->get('ai_key') }}">
                                </div>

                                <div class="row row-cols-2 align-items-end">
                                    <div class="col">
                                        <label class="form-label">{{ tt_trans('App status') }}</label>
                                        <input class="toggle-one" name="ai_status"
                                            {{ tc()->get('ai_status') ? 'checked' : '' }} type="checkbox"
                                            data-on="Active" data-off="Disable" data-onstyle="success"
                                            data-offstyle="danger" data-width="100%">
                                    </div>
                                    <div class="col">
                                        <button type="submit"
                                            class="btn btn-light-primary w-100">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade {{ activeTab('kyc', true) }}" id="tab-3-tab-pane" role="tabpanel"
            aria-labelledby="tab-3-tab" tabindex="0">
            <div class="card">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                    <h4 class="card-title mb-0">{{ tt_trans('KYC Settings', cons()::LANGUAGE_BACKEND) }}</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('panel.kyc-update') }}" method="post">
                        @csrf
                        <div class="row gy-3" id="allRequirement">
                            @forelse ($kycSettings as $setting)
                                <div class="col-12 single-requirement">
                                    <div class="row g-3 align-items-end">
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <input type="text" name="kyc[{{ $loop->index }}][label_name]"
                                                class="form-control" placeholder="Enter Label Name"
                                                value="{{ $setting->label_name }}">
                                        </div>


                                        <div class="col-xxl-3 col-xl-4 col-lg-6 col-12">
                                            <label
                                                class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup>
                                                <span class="error usernameError text-danger text-xs"></span>
                                            </label>
                                            <input type="text" name="kyc[{{ $loop->index }}][field_name]"
                                                class="form-control valid" placeholder="Enter Field Name"
                                                value="{{ $setting->field_name }}">
                                        </div>
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <select class="form-select" name="kyc[{{ $loop->index }}][field_type]">
                                                @foreach (cons()->inputTypes as $key => $types)
                                                    <option value="{{ $key }}"
                                                        {{ selectedOption($setting->field_type == $key) }}>
                                                        {{ $types }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <select class="form-select" name="kyc[{{ $loop->index }}][validation]">
                                                @foreach (cons()->validations as $key => $validation)
                                                    <option value="{{ $key }}"
                                                        {{ selectedOption($setting->validation == $key) }}>
                                                        {{ $validation }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        @if ($loop->first)
                                            <div class="col-auto">
                                                <button type="button" id="addRequirement"
                                                    class="btn btn-primary text-lg"><i class="ri-add-line"></i></button>

                                            </div>
                                        @else
                                            <div class="col-auto">
                                                <button type="button" class="btn btn-danger delete text-lg"><i
                                                        class="ri-close-line"></i></button>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 single-requirement">
                                    <div class="row g-3 align-items-end">
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <input type="text" name="kyc[0][label_name]" class="form-control"
                                                placeholder="Enter Label Name">
                                        </div>


                                        <div class="col-xxl-3 col-xl-4 col-lg-6 col-12">
                                            <label
                                                class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup>
                                                <span class="error usernameError"></span>
                                            </label>
                                            <input type="text" name="kyc[0][field_name]" class="form-control valid"
                                                placeholder="Enter Field Name">
                                        </div>
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <select class="form-select" name="kyc[0][field_type]">
                                                @foreach (cons()->inputTypes as $key => $types)
                                                    <option value="{{ $key }}">{{ $types }}</option>
                                                @endforeach

                                            </select>
                                        </div>
                                        <div class="col-auto flex-grow-1">
                                            <label
                                                class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                                <sup class="text-danger">*</sup></label>
                                            <select class="form-select" name="kyc[0][validation]">
                                                @foreach (cons()->validations as $key => $validation)
                                                    <option value="{{ $key }}">{{ $validation }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-auto">
                                            <button type="button" id="addRequirement" class="btn btn-primary text-lg"><i
                                                    class="ri-add-line"></i></button>

                                        </div>
                                    </div>
                                </div>
                            @endforelse



                        </div>

                        <div class="text-end mt-4">
                            <button
                                class="btn btn-primary">{{ tt_trans('Update KYC', cons()::LANGUAGE_BACKEND) }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="tab-pane fade {{ activeTab('maintanance', true) }}" id="maintanance" role="tabpanel"
            aria-labelledby="tab-4-tab" tabindex="0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{ tt_trans('Maintanance Settings', cons()::LANGUAGE_BACKEND) }}
                            </h4>
                        </div>
                        <div class="card-body">

                            <form action="{{ route('panel.maintanance-update') }}" method="post">
                                @csrf

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ tt_trans('Maintanance title', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="maintanance_title" class="form-control"
                                        value="{{ tc()->get('maintanance_title') }}">
                                </div>
                                <div class="mb-3 summer-note-form">
                                    <label
                                        class="form-label">{{ tt_trans('description', cons()::LANGUAGE_BACKEND) }}</label>
                                    <textarea name="maintanance_description" class="form-control summernote" cols="12" rows="12">{{ tc()->get('maintanance_description') }}</textarea>
                                </div>

                                <div class="row">

                                    <div class="mb-3 col-md-6">
                                        <label
                                            class="form-label">{{ tt_trans('Facebook Link', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="maintanance_social[facebook_link]"
                                            class="form-control"
                                            value="{{ tc()->get('maintanance_social')['facebook_link'] ?? '' }}">
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label
                                            class="form-label">{{ tt_trans('Twitter Link', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="maintanance_social[twitter_link]"
                                            class="form-control"
                                            value="{{ tc()->get('maintanance_social')['twitter_link'] ?? '' }}">
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label
                                            class="form-label">{{ tt_trans('Linkedin Link', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="maintanance_social[linkdin_link]"
                                            class="form-control"
                                            value="{{ tc()->get('maintanance_social')['linkdin_link'] ?? '' }}">
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label
                                            class="form-label">{{ tt_trans('Pinterest Link', cons()::LANGUAGE_BACKEND) }}</label>
                                        <input type="text" name="maintanance_social[pinterest_link]"
                                            class="form-control"
                                            value="{{ tc()->get('maintanance_social')['pinterest_link'] ?? '' }}">
                                    </div>
                                </div>



                                <div class="text-end mt-4">
                                    <button
                                        class="btn btn-primary">{{ tt_trans('Update maintanance', cons()::LANGUAGE_BACKEND) }}</button>
                                </div>

                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>


        <div class="tab-pane fade {{ activeTab('cron', true) }}" id="tab-4-tab-pane" role="tabpanel"
            aria-labelledby="tab-4-tab" tabindex="0">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{ tt_trans('Seo Settings', cons()::LANGUAGE_BACKEND) }}</h4>
                        </div>
                        <div class="card-body">

                            <form action="{{ route('panel.seo-update') }}" method="post">
                                @csrf


                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ tt_trans('Seo meta tag', cons()::LANGUAGE_BACKEND) }}</label>
                                    <select class="form-select-two form-select-two-tokenizer" multiple="multiple"
                                        name="seo_tags[]">
                                        @if (tc()->get('seo_tags'))
                                            @foreach (tc()->get('seo_tags') as $tag)
                                                <option value="{{ $tag }}" selected>{{ $tag }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                                <div>
                                    <label
                                        class="form-label">{{ tt_trans('Seo description', cons()::LANGUAGE_BACKEND) }}</label>
                                    <textarea name="seo_description" class="form-control" cols="12" rows="12">{{ tc()->get('seo_description') }}</textarea>
                                </div>

                                <div class="text-end mt-4">
                                    <button
                                        class="btn btn-primary">{{ tt_trans('Update Seo', cons()::LANGUAGE_BACKEND) }}</button>
                                </div>

                            </form>
                        </div>
                    </div>
                    <div class="card mt-4">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{ tt_trans('Cronjob Settings', cons()::LANGUAGE_BACKEND) }}
                            </h4>
                        </div>
                        <div class="card-body">

                            <div class="mb-3">
                                <label
                                    class="form-label">{{ tt_trans('Cron setup url', cons()::LANGUAGE_BACKEND) }}</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Enter Cron Job URL"
                                        value="curl -s {{ route('cron') }}" readonly>
                                    <button type="button"
                                        class="input-group-text copy-btn">{{ tt_trans('Copy', cons()::LANGUAGE_BACKEND) }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                            <h4 class="card-title mb-0">{{ tt_trans('Cookie Settings', cons()::LANGUAGE_BACKEND) }}</h4>
                            <div>
                                <input class="toggle-one changeStatus" {{ tc()->get('cookie_status') ? 'checked' : '' }}
                                    type="checkbox" data-on="Active" data-off="Disable" data-onstyle="success"
                                    data-offstyle="danger" data-width="100">
                            </div>
                        </div>
                        <div class="card-body">

                            <form action="{{ route('panel.seo-update') }}" method="post">
                                @csrf

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ tt_trans('Cookie title', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="cookie_title" class="form-control"
                                        placeholder="Enter title" value="{{ tc()->get('cookie_title') }}">
                                </div>

                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ tt_trans('Cookie button text', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="cookie_text" class="form-control"
                                        placeholder="Enter Button Text" value="{{ tc()->get('cookie_text') }}">
                                </div>
                                <div class="mb-3">
                                    <label
                                        class="form-label">{{ tt_trans('Cookie short description', cons()::LANGUAGE_BACKEND) }}</label>
                                    <textarea name="cookie_short_description" class="form-control" cols="12" rows="4">{{ tc()->get('cookie_short_description') }}</textarea>
                                </div>
                                <div class="mb-3 summer-note-form">
                                    <label
                                        class="form-label">{{ tt_trans('Cookie details', cons()::LANGUAGE_BACKEND) }}</label>
                                    <textarea name="cookie_details" class="summernote">{{ tc()->get('cookie_details') }}</textarea>
                                </div>


                                <div class="text-end mt-4">
                                    <button
                                        class="btn btn-primary">{{ tt_trans('Update Cookie', cons()::LANGUAGE_BACKEND) }}</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection



@push('script')
    <script>
        $(function() {
            'use strict'
            $('.toggle-one').bootstrapToggle();

            $('.changeStatus').on('change', function() {
                changeStatus('Setting', 'cookie_status', "{{ tc()->get('id') }}");
            })

            let indexKyc = {{ $kycSettings->count() ? $kycSettings->count() : 1 }};

            // Function to add a new requirement row
            $('#addRequirement').on('click', function() {
                $('#allRequirement').append(`
                <div class="col-12 single-requirement">
                    <div class="row g-3 align-items-end">
                       <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Label name', cons()::LANGUAGE_BACKEND) }}
                                            <sup class="text-danger">*</sup></label>
                                        <input type="text" name="kyc[${indexKyc}][label_name]" class="form-control"
                                            placeholder="Enter Label Name">
                                    </div>


                                    <div class="col-xxl-3 col-xl-4 col-lg-6 col-12">
                                        <label class="form-label">{{ tt_trans('Field name', cons()::LANGUAGE_BACKEND) }}
                                            <sup class="text-danger">*</sup>
                                            <span class="error usernameError"></span>
                                        </label>
                                        <input type="text" name="kyc[${indexKyc}][field_name]" class="form-control valid"
                                            placeholder="Enter Field Name">
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label class="form-label">{{ tt_trans('Field type', cons()::LANGUAGE_BACKEND) }}
                                            <sup class="text-danger">*</sup></label>
                                        <select class="form-select" name="kyc[${indexKyc}][field_type]">
                                            @foreach (cons()->inputTypes as $key => $types)
                                                <option value="{{ $key }}">{{ $types }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                    <div class="col-auto flex-grow-1">
                                        <label
                                            class="form-label">{{ tt_trans('Field validation', cons()::LANGUAGE_BACKEND) }}
                                            <sup class="text-danger">*</sup></label>
                                        <select class="form-select" name="kyc[${indexKyc}][validation]">
                                            @foreach (cons()->validations as $key => $validation)
                                                <option value="{{ $key }}">{{ $validation }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-danger delete text-lg"><i class="ri-close-line"></i></button>
                        </div>
                    </div>
                </div>
            `);

                indexKyc++;

            });

            // Function to remove a requirement row
            $(document).on('click', '.delete', function() {
                $(this).closest('.single-requirement').remove();
            });

            $(document).on('keyup', '.valid', function(event) {
                var pattern = /^[a-zA-Z0-9]+$/;
                var isValid = true;

                var inputVal = $(this).val();

                var sanitizedVal = inputVal.replace(/[^a-zA-Z0-9]/g, '');

                $(this).val(sanitizedVal);

                var errorElement = $(this).parent().find('.usernameError');

                // Check if the input value matches the pattern
                if (pattern.test(inputVal)) {
                    errorElement.text('');
                } else {
                    errorElement.text(
                        'Only alphanumeric characters are allowed.'
                    );
                    isValid = false;
                }

            })
        });
    </script>
@endpush
