@extends('backend.layouts.master')


@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap gap-2 justify-content-between align-items-center">
            <h4 class="card-title mb-0">{{ tt_trans('Manage Staffs', cons()::LANGUAGE_BACKEND) }}</h4>
            <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#add">
                <i class="ri-add-circle-line"></i> {{ tt_trans('Add New Staff', cons()::LANGUAGE_BACKEND) }}
            </button>
        </div>
        <div class="card-body">

            <x-table :paginations="$admins">
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>
                        {{ tt_trans('Username', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-user-follow-line"></i>
                        {{ tt_trans('Role Names', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>
                <x-slot name="tablebody">
                    @forelse ($admins as $admin)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('staff', $admin->image) }}" alt="image" class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-1">{{ $admin->username }}</h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted">{{ $admin->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    @foreach ($admin->roles as $role)
                                        <span class="badge badge-light">{{ $role->name }}</span>
                                    @endforeach

                                </div>
                            </td>
                            <td>
                                <?= status($admin) ?>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <button type="button" class="btn btn-icon btn-primary rounded-circle edit"
                                        data-bs-toggle="modal" data-admin="{{ $admin }}"
                                        data-action="{{ route('panel.admins.update', $admin->id) }}"
                                        data-bs-target="#edit">
                                        <i class="ri-edit-line"></i>
                                    </button>
                                    <x-delete-button
                                        action="{{ route('panel.admins.destroy', $admin->id) }}"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>
            </x-table>

        </div>
    </div>



    <x-modal title="Add New Staff" id="add">
        <form method="POST" enctype="multipart/form-data" action="{{ route('panel.admins.store') }}">
            @csrf
            <div class="row gy-3">
                <div class="col-12">
                    <label class="form-label">{{ tt_trans('Image', cons()::LANGUAGE_BACKEND) }}</label>
                    <input class="form-control" name="image" type="file" id="formFile">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Username', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="username" class="form-control" placeholder="{{tt_back('Enter Username')}}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="Email" name="email" class="form-control" placeholder="{{tt_back('Enter Email')}}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Password', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="password" name="password" class="form-control" placeholder="{{tt_back('Enter Password')}}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Confirm Password', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="password" name="password_confirmation" class="form-control"
                        placeholder="{{tt_back('Enter Confirmation Password')}}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Roles', cons()::LANGUAGE_BACKEND) }}</label>
                    <select class="form-select-two" name="roles[]" multiple="multiple">
                        @foreach ($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                        @endforeach

                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</label>
                    <select class="form-select-two" name="status">
                        <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="{{ cons()::INACTIVE }}">{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}
                        </option>
                    </select>
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Save Now', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>


    <x-modal title="Update Staff" id="edit">
        <form method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row gy-3">
                <div class="col-12">
                    <label class="form-label">{{ tt_trans('Image', cons()::LANGUAGE_BACKEND) }}</label>
                    <input class="form-control" name="image" type="file" id="formFile">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Username', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="username" class="form-control" placeholder="Enter Username">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="Email" name="email" class="form-control" placeholder="Enter Email">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Password', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="password" name="password" class="form-control" placeholder="Enter Password">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Confirm Password', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="password" name="password_confirmation" class="form-control"
                        placeholder="Enter Confirmation Password">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Roles', cons()::LANGUAGE_BACKEND) }}</label>
                    <select class="form-select-two editoption" name="roles[]" multiple="multiple">

                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label">{{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</label>
                    <select class="form-select" name="status">
                        <option value="{{ cons()::ACTIVE }}">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="{{ cons()::INACTIVE }}">{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}
                        </option>
                    </select>
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Update Now', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>


@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('select2.min.css', cons()::ASSETS_FROM_COMMON) }}">
@endpush

@push('script')
    <script src="{{ js('select2.min.js', cons()::ASSETS_FROM_COMMON) }}"></script>

    <script>
        $(function() {
            'use strict'

            $('.form-select-two').select2({
                placeholder: 'Select an option'
            });

            function getOptions(admin) {

                $.ajax({
                    url: '{{ route('panel.get.options') }}', // Route to fetch options
                    data: {
                        admin: admin
                    },
                    success: function(response) {
                        $('.editoption').html(response).trigger('change').select2()
                    }
                })
            }


            $('.edit').on('click', function() {

                $('#edit').find('form').attr('action', $(this).data('action'))

                $('#edit').find('input[name=username]').val($(this).data('admin').username)
                $('#edit').find('input[name=email]').val($(this).data('admin').email)
                $('#edit').find('select[name=status]').val($(this).data('admin').status)

                getOptions($(this).data('admin').id)

            })


        })
    </script>
@endpush
