@extends('backend.layouts.master')

@section('panel')
    <form method="POST" action="{{ route('panel.stage.update', $stage->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row gy-4">
            <div class="col-xxl-12">
                <div class="card">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                        <h4 class="card-title mb-0">{{ tt_trans('Update Stage') }}</h4>

                        <a href="{{ route('panel.stage.index') }}" class="btn btn-sm btn-light"><i
                                class="ri-arrow-left-line"></i>{{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
                    </div>
                    <div class="card-body">
                        <div class="row gy-2">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="text" name="title" value="{{ $stage->title }}" class="form-control"
                                        required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        class="form-label">{{ tt_trans('Token Issue', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div class="input-group">
                                        <input type="number" name="token_issues" value="{{ $stage->token_issues }}"
                                            class="form-control" required>
                                        <span class="input-group-text">{{ $setting->token_symbol }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Base Price', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="base_price"
                                            value="{{ $stage->base_price }}" class="form-control" required>
                                        <span class="input-group-text">{{ tc()->get('currency') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        class="form-label">{{ tt_trans('Bonus Token', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div class="input-group">
                                        <input type="number" name="bonus_token" value="{{ $stage->bonus_token }}"
                                            class="form-control">
                                        <span class="input-group-text">{{ $setting->token_symbol }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Soft Cap', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div class="input-group">
                                        <input type="number" name="soft_cap" value="{{ $stage->soft_cap }}"
                                            class="form-control">
                                        <span class="input-group-text">{{ $setting->token_symbol }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Hard Cap', cons()::LANGUAGE_BACKEND) }}</label>
                                    <div class="input-group">
                                        <input type="number" name="hard_cap" value="{{ $stage->hard_cap }}"
                                            class="form-control">
                                        <span class="input-group-text">{{ $setting->token_symbol }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label
                                        class="form-label">{{ tt_trans('Start Date', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="datetime-local" required name="start_date"
                                        value="{{ $stage->start_date }}" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('End Date', cons()::LANGUAGE_BACKEND) }}</label>
                                    <input type="datetime-local" required name="end_date" value="{{ $stage->end_date }}"
                                        class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">{{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</label>
                                    <select class="form-select" name="status" required>
                                        <option value="{{ cons()::ACTIVE }}" @selected($stage->status == cons()::ACTIVE)>
                                            {{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                                        <option value="{{ cons()::INACTIVE }}" @selected($stage->status == cons()::INACTIVE)>
                                            {{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                                    </select>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <button type="submit"
                class="btn btn-primary mt-4">{{ tt_trans('Update Stage', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </form>
@endsection


@push('script')
    <script src="{{ js('drop-zone.js', cons()::ASSETS_FROM_BACKEND) }}"></script>
@endpush
