@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('All Subscribers', cons()::LANGUAGE_BACKEND) }}</h4>

            <div class="d-flex flex-wrap align-items-center gap-2">
                <form class="d-flex align-items-center gap-2" method="GET">
                    <div class="position-relative">
                        <input type="text" name="name" class="form-control form-control-sm ps-35" placeholder="Email"
                            value="{{ request()->email }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>

                    @if (request()->has('name'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i>
                        <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>
                </form>

                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#bulk">
                    <i class="ri-mail-send-line"></i>
                    <span>{{ tt_trans('Bulk Mail', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </div>


        </div>
        <div class="card-body">
            <x-table :paginations="$subscribers">
                <tr>
                    <th scope="col"><i class="ri-profile-line"></i> {{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-file-list-3-line"></i> {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($subscribers as $subscriber)
                        <tr>

                            <td>
                                {{ $subscriber->email }}
                            </td>
                            <td>
                                {{ dateFormatter($subscriber->created_at) }}
                            </td>
                            <td>
                                <button class="btn btn-icon btn-primary rounded-circle email" data-bs-toggle="modal"
                                    data-bs-target="#email"
                                    data-action="{{ route('panel.subscriber-mail', $subscriber->id) }}">
                                    <i class="ri-mail-line"></i>
                                </button>

                                <x-delete-button></x-delete-button>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse

                </x-slot>
            </x-table>

        </div>
    </div>

    <x-modal title="Send Bulk Mail" id="bulk">
        <form method="POST" action="{{ route('panel.subscriber-bulk-mail') }}">
            @csrf
            <div class="row g-3">
                <div class="col-lg-12">
                    <label class="form-label">{{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <input type="text" name="subject" class="form-control" placeholder="Enter Subject">
                </div>

                <div class="col-12">
                    <label class="form-label">{{ tt_trans('Message', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <textarea class="summernote" name="message"></textarea>
                </div>
                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Submit', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>


    <x-modal title="Send Email" id="email">
        <form method="POST" >
            @csrf
            <div class="row g-3">
                <div class="col-lg-12">
                    <label class="form-label">{{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <input type="text" name="subject" class="form-control" placeholder="Enter Subject">
                </div>

                <div class="col-12">
                    <label class="form-label">{{ tt_trans('Message', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <textarea class="summernote" name="message"></textarea>
                </div>
                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Submit', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('.email').on('click', function() {
                $('#email').find('form').attr('action', $(this).data('action'))
            })

        })
    </script>
@endpush
