@extends('backend.layouts.master')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-xxl-10">
            <div class="card">
                <div class="card-header d-flex flex-wrap gap-2 align-items-center justify-content-between">
                    <div>
                        <h4 class="card-title mb-1">{{ $support->title }}</h4>
                        <ul class="d-flex flex-wrap gap-sm-3 gap-2 align-items-center text-sm">
                            <li class="text-primary fw-semibold"><i class="ri-hashtag"></i> {{ $support->trx }}</li>
                            <li><i class="ri-calendar-line"></i>{{ dateFormatter($support->created_at) }}</li>

                            @if ($support->status == cons()::SUPPORT_OPEN)
                                <span class="badge badge-light-success">{{ tt_front('Open') }}</span>
                            @elseif($support->status == cons()::SUPPORT_ANSWERED)
                                <span class="badge badge-light-success">{{ tt_front('Answered') }}</span>
                            @else

                                <span class="badge badge-light-danger">{{ tt_front('Closed') }}</span>

                            @endif
                        </ul>
                    </div>
                    <div class="d-flex gap-2 align-items-center">
                        @if($support->status != cons()::SUPPORT_CLOSED)
                        <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                            data-bs-target="#closeTicketModal"><i class="ri-close-circle-line"></i>
                            {{ tt_trans('Close Ticket', cons()::LANGUAGE_BACKEND) }}</button>
                        @endif
                        <a href="{{ route('panel.support') }}" class="btn btn-sm btn-light"><i
                                class="ri-arrow-left-line"></i>
                            {{ tt_trans('Back', cons()::LANGUAGE_BACKEND) }}</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="all-reply-body">
                        @forelse ($support->messages as $message)
                            @if ($message->type == 'user')
                                <div class="d-sm-flex gap-3 border border-light bg-light-light p-3 rounded-3">
                                    <img src="{{ getFile('user', $support->user->image) }}" alt="user image"
                                        class="avatar-xl flex-shrink-0 rounded-circle">
                                    <div class="flex-grow-1 mt-sm-0 mt-2">
                                        <div class="d-flex flex-wrap align-items-center gap-2 justify-content-between mb-2">
                                            <h6 class="mb-0 text-md">{{ $support->user->username }}</h6>
                                            <span class="text-sm">{{ $message->created_at->diffforhumans() }}</span>
                                        </div>
                                        <p class="mb-0">{{ $message->message }}</p>
                                        <div class="d-flex flex-wrap gap-sm-3 gap-2 align-items-center mt-2">
                                            @foreach ($message->files as $file)
                                                <a href="{{ route('panel.support.download', $file->id) }}"
                                                    class="text-primary"><i class="ri-file-line"></i>
                                                    {{ $file->file }}</a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="d-sm-flex gap-3 border border-light-primary bg-light-primary p-3 rounded-3">
                                    <img src="{{ getFile('staff', $message->admin->image) }}" alt="user image"
                                        class="avatar-xl flex-shrink-0 rounded-circle">
                                    <div class="flex-grow-1 mt-sm-0 mt-2">
                                        <div class="d-flex flex-wrap align-items-center gap-2 justify-content-between mb-2">
                                            <h6 class="mb-0 text-md">{{ $message->admin->username }}</h6>
                                            <span class="text-sm">{{ $message->created_at->diffforhumans() }}</span>
                                        </div>
                                        <p class="mb-0">
                                            {{ $message->message }}
                                        </p>
                                        @foreach ($message->files as $file)
                                            <a href="{{ route('panel.support.download', $file->id) }}"
                                                class="text-primary"><i class="ri-file-line"></i>
                                                {{ $file->file }}</a>
                                        @endforeach
                                    </div>
                                </div><!-- admin reply -->
                            @endif
                            <hr>
                        @empty
                        @endforelse

                    </div>
                </div>
                @if($support->status != cons()::SUPPORT_CLOSED)
                <div class="card-footer">
                    <form method="POST" action="{{ route('panel.support.reply', $support->id) }}"
                        enctype="multipart/form-data">
                        @csrf
                        <textarea name="message" cols="6" rows="6" class="form-control" placeholder="Write Reply...">{{ old('message') }}</textarea>

                        <div id="allFiles">

                        </div>


                        <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mt-3">
                            <button type="button" id="addFiles" class="btn btn-sm btn-light-primary"><i
                                    class="ri-file-add-line"></i>
                                {{ tt_front('Add Files') }}</button>
                            <button type="submit" class="btn btn-sm btn-primary"><i class="ri-reply-line"></i>
                                {{ tt_front('Reply') }}</button>
                        </div>

                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>

    <x-modal id="closeTicketModal" size="" :isHeader="false">
        <div class="d-flex flex-column justify-content-center align-items-center text-center">
            <div class="card-icon-lg bg-light-danger text-danger text-2xl item-center rounded-circle">
                <iconify-icon icon="ant-design:alert-outlined"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Are You Sure', cons()::LANGUAGE_BACKEND) }}?</h5>
            <p class="text-muted mb-0">{{ tt_trans('This will', cons()::LANGUAGE_BACKEND) }} <span
                    class="text-danger">{{ tt_trans('close this ticket permanently', cons()::LANGUAGE_BACKEND) }}</span>.
                {{ tt_trans('You cant undo this action', cons()::LANGUAGE_BACKEND) }}.</p>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <form action="{{route('panel.support.closed', $support->id)}}" method="post">
                    @csrf
                    <button type="submit" class="btn btn-danger">{{ tt_trans('Close Ticket', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>
        </div>
    </x-modal>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            'use strict'


            $('#addFiles').on('click', function() {
                $('#allFiles').append(`
                <div class="mt-3 single-file d-flex align-items-end gap-2">
                    <div class="flex-grow-1">
                        <input class="form-control form-control-sm" type="file" name="files[]">
                    </div>
                    <button type="button" class="btn btn-sm btn-danger flex-shrink-0"><i class="ri-close-line"></i></button>
                </div>
            `);
            });

            // Function to remove a file
            $(document).on('click', '.btn-danger', function() {
                $(this).closest('.single-file').remove();
            });
        });
    </script>
@endpush
