@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_trans('All Tickets', cons()::LANGUAGE_BACKEND) }}</h4>
                <form class="d-flex flex-wrap align-items-center gap-2">
                    <div class="position-relative">
                        <input type="text" name="trx" class="form-control form-control-sm ps-35"
                            placeholder="{{tt_back('Ticket ID...')}}" value="{{request()->trx}}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <div>
                        <select class="form-select form-select-sm" name="sort">
                            <option value="">{{ tt_trans('All Tickets', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="open">{{ tt_trans('Open Tickets', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="answered">{{ tt_trans('Answered Tickets', cons()::LANGUAGE_BACKEND) }}</option>
                            <option value="closed">{{ tt_trans('Closed Tickets', cons()::LANGUAGE_BACKEND) }}</option>
                        </select>
                    </div>

                    @if (request()->has('sort') || request()->has('trx'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i> {{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}
                    </button>
                </form>
            </div>
        </div>
        <div class="card-body">

            <x-table :paginations="$supports">
                <tr>
                    <th scope="col"><i class="ri-id-card-line"></i> {{ tt_trans('Ticket ID', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-account-circle-line"></i>
                        {{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-file-list-2-line"></i>
                        {{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($supports as $support)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="text-warning"><i class="ri-circle-fill"></i></span>
                                    <p class="mb-0 display-color fw-medium"><a href="{{route('panel.support-details', $support->id)}}">
                                        #{{ $support->trx }}</a> </p>
                                </div>
                                <p class="text-xs mb-0 line-height-1 ms-4">{{ dateFormatter($support->created_at) }}</p>
                            </td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('user', $support->user->image) }}" alt="image"
                                        class="avatar-lg rounded-circle">
                                    <div>
                                        <h6 class="text-sm mb-1 text-line-1 w-150px">{{ $support->user->username }}</h6>
                                        <p class="text-xs mb-0 line-height-1 text-muted text-line-1 w-150px">{{ $support->user->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <p class="mb-0">{{ $support->title }}</p>
                            </td>
                            <td>
                                @if ($support->status == cons()::SUPPORT_OPEN)
                                    <span class="badge badge-success">{{ tt_front('Open') }}</span>
                                @elseif($support->status == cons()::SUPPORT_ANSWERED)
                                    <span class="badge badge-success">{{ tt_front('Answered') }}</span>
                                @else
                                    <span class="badge badge-danger">{{ tt_front('Closed') }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="{{ route('panel.support-details', $support->id) }}"
                                        class="btn btn-icon btn-primary rounded-circle">
                                        <i class="ri-eye-line"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>
            </x-table>
        </div>
    </div>
@endsection
