<hr class="my-5">
<div class="row gy-3 align-items-center">
    <div class="col-xxl-4">
        <h5 class="text-md mb-0">{{ tt_trans('Customize theme color', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-muted text-sm mb-0">
            {{ tt_trans('Customize your ui theme color', cons()::LANGUAGE_BACKEND) }}.</p>
    </div>
    <div class="col-xxl-8">
        <div class="row">
            <div class="col-sm-6">
                <label class="form-label">{{ tt_trans('Primary color', cons()::LANGUAGE_BACKEND) }}</label>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" placeholder="Enter Color Code"
                        value="{{ $theme->primary_color }}" name="primary_color" id="themeColorInput">
                    <span class="input-group-text text-sm text-white" id="themeColorPreview"
                        style="background-color: {{ $theme->primary_color }};">{{ tt_trans('Color preview', cons()::LANGUAGE_BACKEND) }}</span>
                </div>
            </div>
            <div class="col-sm-6">
                <label class="form-label">{{ tt_trans('Secondary color', cons()::LANGUAGE_BACKEND) }}</label>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" placeholder="Enter Color Code"
                        value="{{ $theme->secondary_color }}" name="secondary_color" id="surfaceColorInput">
                    <span class="input-group-text text-sm text-white" id="surfaceColorPreview"
                        style="background-color: {{ $theme->secondary_color }};">{{ tt_trans('Color preview', cons()::LANGUAGE_BACKEND) }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<hr class="my-5">

<div class="row gy-3 align-items-center">
    <div class="col-xxl-4">
        <h5 class="text-md mb-0">{{ tt_trans('Customize theme Logo and icons', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-muted text-sm mb-0">
            {{ tt_trans('Customize your ui theme logo, icons', cons()::LANGUAGE_BACKEND) }}.</p>
    </div>

    <div class="col-xxl-8">
        <div class="row">
            @php
                $logo = asset("files/image/{$theme->title}/logo/{$theme->logo}");
                $dark = asset("files/image/{$theme->title}/logo/{$theme->dark_logo}");
                $icon = asset("files/image/{$theme->title}/icon/{$theme->icon}");
            @endphp

            <x-image-upload title="White Logo" id="single-1" name="logo" :image="$logo"
                parent="col-md-4"></x-image-upload>
            <x-image-upload title="Dark Logo" id="single-4" :image="$dark" name="dark_logo"
                parent="col-md-4"></x-image-upload>
            <x-image-upload title="Icon Upload" id="single-2" name="icon" :image="$icon"
                parent="col-md-4"></x-image-upload>
        </div>
    </div>


</div>




<hr class="my-5">

<div class="row gy-3 align-items-center">
    <div class="col-xxl-4">
        <h5 class="text-md mb-0">{{ tt_trans('Customize theme fonts', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-muted text-sm mb-0">
            {{ tt_trans('Customize your ui theme fonts', cons()::LANGUAGE_BACKEND) }}.</p>
    </div>

    <div class="col-xxl-8">
        <div class="row">
            <div class="col-lg-6 mb-3">
                <label class="form-label">{{ tt_trans('Heading fonts url', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="heading_font" class="form-control" placeholder="Enter Font URL"
                    value="{{ $theme->heading_font }}">
            </div>
            <div class="col-lg-6 mb-3">
                <label class="form-label">{{ tt_trans('Heading font family', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="heading_font_family" class="form-control" placeholder="Enter Font Family"
                    value="{{ $theme->heading_font_family }}">
            </div>
            <div class="col-lg-6 mb-3">
                <label class="form-label">{{ tt_trans('Paragraph fonts url', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="paragraph_font" class="form-control" placeholder="Enter Font URL"
                    value="{{ $theme->paragraph_font }}">
            </div>
            <div class="col-lg-6 mb-3">
                <label class="form-label">{{ tt_trans('Paragraph font family', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="paragraph_font_family" class="form-control" placeholder="Enter Font Family"
                    value="{{ $theme->paragraph_font_family }}">
            </div>
        </div>
    </div>


</div>
