@extends('backend.layouts.master')

@section('panel')
    <form method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">{{ tt_trans('Theme Settings', cons()::LANGUAGE_BACKEND) }}</h4>
            </div>
            <div class="card-body py-sm-4">
                <div class="row gy-3 align-items-center">
                    <div class="col-xxl-4">
                        <h5 class="text-md mb-0">{{ tt_trans('Interface theme', cons()::LANGUAGE_BACKEND) }}</h5>
                        <p class="text-muted text-sm mb-0">
                            {{ tt_trans('Select or customize your ui theme', cons()::LANGUAGE_BACKEND) }}.</p>
                    </div>
                    <div class="col-xxl-8">
                        <div class="row gy-4">
                            @foreach ($themes as $theme)
                                <div class="col-md-4 col-sm-6">
                                    <div class="border border-light border-2 rounded-3 shadow-sm theme-item">
                                        @if ($theme->is_active)
                                            <span
                                                class="theme-active-badge bg-success">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</span>
                                        @endif
                                        <img src="{{ getFile('common', $theme->title . '.jpg', '200x200') }}"
                                            alt="theme image" class="rounded-3 w-100">
                                        <div class="py-3 px-3 border-top border-light text-center">
                                            <div class="form-check d-inline-flex flex-wrap align-items-center gap-2">
                                                <input class="form-check-input" type="radio" name="theme"
                                                    value="{{ $theme->id }}" id="themeRadio1"
                                                    @checked($theme->is_active) data-primary="{{ $theme->primary_color }}"
                                                    data-secondary="{{ $theme->secondary_color }}">
                                                <label class="form-label mb-0" for="themeRadio1">
                                                    {{ $theme->title }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div id="theme-settings">

                </div>

                <div class="text-end mt-4">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Save Changes', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </div>
    </form>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('input[name="theme"]').on("change", function() {

                let theme = $(this).val();

                sendHttpRequest('GET', "{{ url()->current() }}", {
                    theme: theme
                }, '#theme-settings')
            });

            $('input[name="theme"]:checked').trigger('change');
        })
    </script>
@endpush
