@extends('backend.layouts.master')

@section('panel')
    <div class="row gy-4 justify-content-center">
        <div class="col-xl-3 col-lg-6 col-md-8">
            <div class="card">
                <div class="card-body p-sm-4 p-3">
                    <div class="text-center">
                        <div class="d-inline-block position-relative">
                            <img src="{{ getFile('user', $user->image) }}" alt="user image" class="avatar-6xl rounded-circle">
                            <span
                                class="badge {{ $user->ability?->kyc_verified ? 'badge-success' : 'badge-danger' }} position-absolute bottom-10 end-0"
                                data-bs-toggle="tooltip"
                                data-bs-title="{{ $user->ability?->kyc_verified ? 'KYC verified' : 'KYC unverified' }}">
                                @if ($user->ability?->kyc_verified)
                                    <i class="ri-check-double-line"></i>
                                @else
                                    <i class="ri-question-line"></i>
                                @endif
                                {{ tt_trans('KYC', cons()::LANGUAGE_BACKEND) }}
                            </span>
                        </div>
                        <h4 class="mt-4 h5 mb-1">{{ $user->full_name }}</h4>
                        <p class="mb-0 text-sm">{{ $user->email }}</p>
                    </div>
                </div>
                <hr class="m-0">
                <div class="card-body d-flex flex-wrap align-items-center justify-content-center gap-2">
                    <button type="button" data-bs-toggle="modal" data-bs-target="#addBalanceModal">
                        <span class="card-icon bg-success text-white rounded-circle item-center text-xl"
                            data-bs-toggle="tooltip" data-bs-title="Add balance">
                            <iconify-icon icon="hugeicons:wallet-add-01"></iconify-icon>
                        </span>
                    </button>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#subBalanceModal">
                        <span class="card-icon bg-warning text-white rounded-circle item-center text-xl"
                            data-bs-toggle="tooltip" data-bs-title="Subtract balance">
                            <iconify-icon icon="hugeicons:wallet-not-found-01"></iconify-icon>
                        </span>
                    </button>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#sendMailModal">
                        <span class="card-icon bg-info text-white rounded-circle item-center text-xl"
                            data-bs-toggle="tooltip" data-bs-title="Send a mail">
                            <iconify-icon icon="hugeicons:mail-upload-01"></iconify-icon>
                        </span>
                    </button>
                    <a href="{{ route('panel.login-as-user', $user->id) }}" target="_blank">
                        <span class="card-icon bg-primary text-white rounded-circle item-center text-xl"
                            data-bs-toggle="tooltip" data-bs-title="Login as user">
                            <iconify-icon icon="uiw:login"></iconify-icon>
                        </span>
                    </a>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#profileUpdateModal">
                        <span class="card-icon bg-dark text-white rounded-circle item-center text-xl"
                            data-bs-toggle="tooltip" data-bs-title="User profile update">
                            <iconify-icon icon="iconamoon:profile"></iconify-icon>
                        </span>
                    </button>

                </div>
                <hr class="m-0">
                <div class="card-body py-4">
                    <p class="mb-3 text-xs fw-medium text-uppercase">{{ tt_trans('IN ACCOUNT', cons()::LANGUAGE_BACKEND) }}
                    </p>
                    <div class="row g-3">
                        <div class="col-xxl-6">
                            <h5 class="mb-1">{{ formatter($user->balance) }} <span
                                    class="fw-normal">{{ tc()->get('currency') }}</span></h5>
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('Total Balance', cons()::LANGUAGE_BACKEND) }}
                            </p>
                        </div>
                        <div class="col-xxl-6">
                            <h5 class="mb-1">{{ formatter($user->earnings->sum('amount')) }} <span
                                    class="fw-normal">{{ tc()->get('currency') }}</span></h5>
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('Total Earning', cons()::LANGUAGE_BACKEND) }}
                            </p>
                        </div>
                    </div>
                </div>
                <hr class="m-0">
                <div class="card-body py-4">
                    <p class="mb-3 text-xs fw-medium text-uppercase">{{ tt_trans('ADDITIONAL', cons()::LANGUAGE_BACKEND) }}
                    </p>
                    <div class="row g-3">
                        <div class="col-6">
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('User Name', cons()::LANGUAGE_BACKEND) }}:</p>
                            <h5 class="mb-1 text-sm fw-medium">{{ $user->username }}</h5>
                        </div>
                        <div class="col-6">
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('Last Login', cons()::LANGUAGE_BACKEND) }}:</p>
                            <h5 class="mb-1 text-sm fw-medium">{{ dateformatter($user->last_login_at) }}</h5>
                        </div>
                        <div class="col-6">
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('User Status', cons()::LANGUAGE_BACKEND) }}:</p>
                            @if ($user->ability->status)
                                <h5 class="mb-1 text-sm fw-medium text-success"><i
                                        class="ri-check-double-line"></i>{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}
                                </h5>
                            @else
                                <h5 class="mb-1 text-sm fw-medium text-danger"><i
                                        class="ri-question-line"></i>{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}
                                </h5>
                            @endif
                        </div>
                        <div class="col-6">
                            <p class="mb-0 text-sm text-muted">{{ tt_trans('Register At', cons()::LANGUAGE_BACKEND) }}:</p>
                            <h5 class="mb-1 text-sm fw-medium">{{ dateformatter($user->created_at) }}</h5>
                        </div>
                    </div>
                </div>
                <hr class="m-0">
                <div class="card-body py-4">
                    <p class="mb-3 text-xs fw-medium text-uppercase">{{ tt_trans('All Status', cons()::LANGUAGE_BACKEND) }}
                    </p>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                <p class="mb-0 text-sm text-muted">{{ tt_trans('User Status', cons()::LANGUAGE_BACKEND) }}:
                                </p>
                                <div class="form-switch form-switch-sm line-height-1">
                                    <input class="form-check-input userstatus" type="checkbox" role="switch" id="status-1"
                                        {{ $user->ability->status ? 'checked' : '' }}>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                <p class="mb-0 text-sm text-muted">{{ tt_trans('Kyc verified') }}:</p>
                                <div class="form-switch form-switch-sm line-height-1">
                                    <input class="form-check-input kycstatus" type="checkbox" role="switch"
                                        id="status-2"
                                        {{ $user->ability->kyc_verified == cons()::ACTIVE ? 'checked' : '' }}>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                <p class="mb-0 text-sm text-muted">{{ tt_trans('Email verified') }}:</p>
                                <div class="form-switch form-switch-sm line-height-1">
                                    <input class="form-check-input emailstatus" type="checkbox" role="switch"
                                        id="status-3"
                                        {{ $user->ability->email_verified == cons()::ACTIVE ? 'checked' : '' }}>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                <p class="mb-0 text-sm text-muted">{{ tt_trans('Sms verified') }}:</p>
                                <div class="form-switch form-switch-sm line-height-1">
                                    <input class="form-check-input smsstatus" type="checkbox" role="switch"
                                        id="status-4"
                                        {{ $user->ability->sms_verified == cons()::ACTIVE ? 'checked' : '' }}>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-xl-9">
            <div class="card border px-3">
                <ul class="nav nav-tabs bordered-tab border-0 nav-tabs-gap-0" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button
                            class="nav-link {{ request()->transactions == '' && request()->deposits == '' && request()->payments == '' && request()->supports == '' ? 'active' : '' }}"
                            id="tab1a-tab" data-bs-toggle="tab" data-bs-target="#overview" type="button"
                            role="tab" aria-controls="overview"
                            aria-selected="true">{{ tt_trans('Overview', cons()::LANGUAGE_BACKEND) }}</button>
                    </li>

                  

                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ request()->transactions ? 'active' : '' }}" id="tab2a-tab"
                            data-bs-toggle="tab" data-bs-target="#transaction" type="button" role="tab"
                            aria-controls="transaction"
                            aria-selected="false">{{ tt_trans('Transactions', cons()::LANGUAGE_BACKEND) }}</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="tab3a-tab" data-bs-toggle="tab" data-bs-target="#deposits"
                            type="button" role="tab" aria-controls="deposits"
                            aria-selected="false">{{ tt_trans('Deposits', cons()::LANGUAGE_BACKEND) }}</button>
                    </li>

                    

                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="tab3a-tab" data-bs-toggle="tab" data-bs-target="#withdraw"
                            type="button" role="tab" aria-controls="withdraw"
                            aria-selected="false">{{ tt_trans('Withdraws', cons()::LANGUAGE_BACKEND) }}</button>
                    </li>

                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="tab3a-tab" data-bs-toggle="tab" data-bs-target="#supports"
                            type="button" role="tab" aria-controls="supports"
                            aria-selected="false">{{ tt_trans('Supports', cons()::LANGUAGE_BACKEND) }}</button>
                    </li>
                </ul>
            </div>

            <div class="mt-4">

                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade {{ request()->transactions == '' && request()->deposits == '' && request()->payments == '' && request()->supports == '' ? 'active show' : '' }}"
                        id="overview" role="tabpanel" aria-labelledby="tab1a-tab" tabindex="0">

                        <div class="row gy-3">
                            <div class="col-lg-3 col-sm-6">
                                <div class="card h-100">
                                    <div class="card-body px-3">
                                        <div class="d-xxl-flex align-items-center gap-3">
                                            <div class="card-icon-lg bg-light-primary text-primary item-center text-xxl rounded-2 flex-shrink-0">
                                                <iconify-icon icon="solar:cash-out-outline"></iconify-icon>
                                            </div>
                                            <div class="flex-grow-1 mt-xxl-0 mt-3">
                                                <p class="mb-0 text-sm">
                                                    {{ tt_trans('Total deposit', cons()::LANGUAGE_BACKEND) }}</p>
                                                <h5 class="mb-0 h6 text-break">
                                                    {{ formatter($user->deposits()->accepted()->sum('total_amount'), true) }}
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="card h-100">
                                    <div class="card-body px-3">
                                        <div class="d-xxl-flex align-items-center gap-3">
                                            <div class="card-icon-lg bg-light-warning text-warning bg-warning item-center text-xxl rounded-2 flex-shrink-0">
                                                <iconify-icon icon="iconoir:hand-cash"></iconify-icon>
                                            </div>
                                            <div class="flex-grow-1 mt-xxl-0 mt-3">
                                                <p class="mb-0 text-sm">
                                                    {{ tt_trans('Total withdraw', cons()::LANGUAGE_BACKEND) }}</p>
                                                <h5 class="mb-0 h6 text-break">
                                                    {{ formatter($user->withdraws()->accepted()->sum('withdraw_amount'), true) }}
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="card h-100">
                                    <div class="card-body px-3">
                                        <div class="d-xxl-flex align-items-center gap-3">
                                            <div
                                                class="card-icon-lg bg-light-success text-success bg-light-success item-center text-xxl rounded-2 flex-shrink-0">
                                                <iconify-icon icon="mage:users"></iconify-icon>
                                            </div>
                                            <div class="flex-grow-1 mt-xxl-0 mt-3">
                                                <p class="mb-0 text-sm">
                                                    {{ tt_trans('Total refferal', cons()::LANGUAGE_BACKEND) }}</p>
                                                <h5 class="mb-0 h6 text-break">{{ $user->referrals->count() }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="card h-100">
                                    <div class="card-body px-3">
                                        <div class="d-xxl-flex align-items-center gap-3">
                                            <div
                                                class="card-icon-lg bg-light-info text-info item-center text-xxl rounded-2 flex-shrink-0">
                                                <iconify-icon icon="mynaui:percentage-waves"></iconify-icon>
                                            </div>
                                            <div class="flex-grow-1 mt-xxl-0 mt-3">
                                                <p class="mb-0 text-sm">
                                                    {{ tt_trans('Total commission', cons()::LANGUAGE_BACKEND) }}</p>
                                                <h5 class="mb-0 h6 text-break">
                                                    {{ formatter($user->myCommissions->sum('amount'), true) }}
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mt-4">
                            <div class="card-header">
                                <h4 class="card-title mb-0">{{ tt_trans('Deposit Statistics', cons()::LANGUAGE_BACKEND) }}
                                </h4>
                            </div>
                            <div class="card-body">
                                @if (count($finalDepositData) > 0 || count($finalWithdrawData) > 0)
                                    <div id="paymentOverview"></div>
                                @else
                                    <div class="no-data-wrapper">
                                        <img src="{{ getFile('common', 'no-data.png') }}" alt="image"
                                            class="no-data-img">
                                        <h4 class="mt-4 mb-0">{{ tt_trans('No Payment Statistics', cons()::LANGUAGE_BACKEND) }}</h4>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="tab-pane fade {{ request()->transactions ? 'active show' : '' }}" id="transaction"
                        role="tabpanel" aria-labelledby="tab2a-tab" tabindex="0">
                        <div class="card">
                            <div class="card-body">
                                <x-table :paginations="$transactions">
                                    <tr>
                                        <th scope="col"><i
                                                class="ri-profile-line"></i>{{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                        </th>
                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>
                                        <th scope="col"><i class="ri-wallet-2-line"></i>
                                            {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                            {{ tt_trans('Type', cons()::LANGUAGE_BACKEND) }}</th>
                                    </tr>

                                    <x-slot name="tablebody">
                                        @forelse ($transactions as $transaction)
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div>
                                                            <h6 class="text-sm mb-0">{{ $transaction->trx }}</h6>
                                                            <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                                                {{ $transaction->reason }}</p>
                                                        </div>
                                                    </div>
                                                </td>

                                                <td>
                                                    {{ dateFormatter($transaction->created_at) }}
                                                </td>

                                                <td>
                                                    {{ formatter($transaction->amount, true) }}
                                                </td>

                                                <td>

                                                    @if ($transaction->type == '+')
                                                        <span class="text-success">
                                                            <i class="ri-add-circle-line"></i>
                                                            {{ tt_trans('Credited', cons()::LANGUAGE_BACKEND) }}
                                                        </span>
                                                    @else
                                                        <span class="text-danger">
                                                            <i class="ri-indeterminate-circle-line"></i>
                                                            {{ tt_trans('Debited', cons()::LANGUAGE_BACKEND) }}
                                                        </span>
                                                    @endif



                                                </td>
                                            </tr>
                                        @empty
                                            <x-no-data></x-no-data>
                                        @endforelse
                                    </x-slot>

                                </x-table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="deposits" role="tabpanel" aria-labelledby="tab3a-tab"
                        tabindex="0">
                        <x-table :paginations="$user->deposits()->paginate(offsetPerPage())">
                            <tr>
                                <th scope="col"><i
                                        class="ri-account-circle-line"></i>{{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}
                                </th>
                                <th scope="col"><i class="ri-profile-line"></i>
                                    {{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                </th>
                                <th scope="col"><i class="ri-calendar-2-line"></i>
                                    {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-secure-payment-line"></i>
                                    {{ tt_trans('Gateway', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-wallet-2-line"></i>
                                    {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-wallet-3-line"></i>
                                    {{ tt_trans('Final Amount', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                    {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                                <th scope="col"><i class="ri-arrow-right-up-line"></i>
                                    {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                            </tr>

                            <x-slot name="tablebody">
                                @forelse ($user->deposits as $deposit)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <img src="{{ getFile('users', $deposit->user->image) }}" alt="image"
                                                    class="avatar-lg rounded-2">
                                                <div>
                                                    <h6 class="text-sm mb-0"><a
                                                            href="{{ route('panel.user.details', $deposit->user_id) }}"
                                                            class="text-primary text-line-1 w-75">{{ $deposit->user->full_name }}</a>
                                                    </h6>
                                                    <p
                                                        class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-120px">
                                                        {{ $deposit->user->email }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td classs="text-wrap">{{ $deposit->trx }}</td>
                                        <td>{{ dateFormatter($deposit->created_at) }}</td>
                                        <td>
                                            <span class="badge badge-light-primary">{{ $deposit->method->name }}</span>
                                        </td>
                                        <td>
                                            {{ formatter($deposit->amount, true) }}
                                        </td>
                                        <td>{{ formatter($deposit->total_amount, true) }}</td>
                                        <td>
                                            <?= status($deposit, '', 'deposit') ?>
                                        </td>
                                        <td>

                                            @if ($deposit->type == cons()::OFFLINE_GATEWAY)
                                                <div class="d-flex flex-wrap align-items-center gap-2">
                                                    <a href="{{ route('panel.offline-deposit-details', $deposit->id) }}"
                                                        class="btn btn-icon btn-primary rounded-circle">
                                                        <i class="ri-eye-line"></i>
                                                    </a>
                                                </div>
                                            @else
                                                <div class="d-flex flex-wrap align-items-center gap-2">
                                                    <a href="javascript:void(0)" data-bs-toggle="modal"
                                                        data-bs-target="#details"
                                                        data-action="{{ route('panel.online-deposit-details', $deposit->id) }}"
                                                        class="btn btn-icon btn-primary rounded-circle details">
                                                        <i class="ri-eye-line"></i>
                                                    </a>
                                                </div>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <x-no-data></x-no-data>
                                @endforelse

                            </x-slot>

                        </x-table>
                    </div>

                    

                    <div class="tab-pane fade {{ request()->withdraws ? 'active show' : '' }}" id="withdraw"
                        role="tabpanel" aria-labelledby="tab3a-tab" tabindex="0">
                        <div class="card">
                            <div class="card-body">
                                <x-table :paginations="$withdraws">
                                    <tr>
                                        <th scope="col"><i
                                                class="ri-profile-line"></i>{{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                        </th>

                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Method', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Getable Amount', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                            {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                                    </tr>

                                    <x-slot name="tablebody">
                                        @forelse ($withdraws as $withdraw)
                                            <tr>
                                                <td>{{ $withdraw->trx }}</td>

                                                <td>
                                                    <span
                                                        class="badge badge-light-primary">{{ $withdraw->method->name }}</span>
                                                </td>
                                                <td>
                                                    {{ formatter($withdraw->withdraw_amount, true) }}
                                                </td>

                                                <td> {{ formatter($withdraw->getable_amount, true) }}</td>
                                                <td>
                                                    <?= status($withdraw) ?>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-wrap align-items-center gap-2">
                                                        <button class="btn btn-icon btn-primary rounded-circle details"
                                                            data-withdraw="{{ $withdraw->id }}" data-bs-toggle="modal"
                                                            data-bs-target="#withdrawDetailsModal">
                                                            <i class="ri-eye-line"></i>
                                                        </button>
                                                        @if ($withdraw->status == cons()::PENDING)
                                                            <button class="btn btn-icon btn-success rounded-circle accept"
                                                                data-action="{{ route('panel.withdraw-accept', $withdraw->id) }}"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#withdrawAcceptModal">
                                                                <i class="ri-check-line"></i>
                                                            </button>
                                                            <button class="btn btn-icon btn-danger rounded-circle reject"
                                                                data-action="{{ route('panel.withdraw-reject', $withdraw->id) }}"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#withdrawRejectModal">
                                                                <i class="ri-forbid-line"></i>
                                                            </button>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <x-no-data></x-no-data>
                                        @endforelse
                                    </x-slot>

                                </x-table>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade {{ request()->supports ? 'active show' : '' }}" id="supports"
                        role="tabpanel" aria-labelledby="tab3a-tab" tabindex="0">
                        <div class="card">
                            <div class="card-body">
                                <x-table :paginations="$supports">
                                    <tr>
                                        <th scope="col"><i
                                                class="ri-profile-line"></i>{{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}
                                        </th>
                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Title', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-calendar-2-line"></i>
                                            {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>

                                        <th scope="col"><i class="ri-checkbox-circle-line"></i>
                                            {{ tt_trans('Details', cons()::LANGUAGE_BACKEND) }}</th>
                                    </tr>

                                    <x-slot name="tablebody">
                                        @forelse ($supports as $support)
                                            <tr>
                                                <td>
                                                    {{ $support->trx }}
                                                </td>

                                                <td>
                                                    {{ $support->title }}
                                                </td>

                                                <td>
                                                    @if ($support->status == cons()::SUPPORT_OPEN)
                                                        <span class="badge badge-success">{{ tt_front('Open') }}</span>
                                                    @elseif($support->status == cons()::SUPPORT_ANSWERED)
                                                        <span
                                                            class="badge badge-light-success">{{ tt_front('Answered') }}</span>
                                                    @else
                                                        <span
                                                            class="badge badge-light-danger">{{ tt_front('Closed') }}</span>
                                                    @endif
                                                </td>

                                                <td>
                                                    <a href="{{ route('panel.support-details', $support->id) }}"
                                                        class="btn btn-icon btn-primary rounded-circle">
                                                        <i class="ri-eye-line"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @empty
                                            <x-no-data></x-no-data>
                                        @endforelse
                                    </x-slot>

                                </x-table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="card mt-4">
        <div class="card-header">
            <h4 class="card-title mb-0">{{ tt_trans('Referral Tree') }}</h4>
        </div>
        <div class="card-body">
            <ul class="referral-tree">
                @include('backend.users.tree', showReferralTree($user, request()->id))
            </ul>
        </div>
    </div>

    <x-modal id="details" title="Deposit Details" bodyId="append">

    </x-modal>

    <x-modal title="Add Balance" id="addBalanceModal" size="">
        <form method="POST" action="{{ route('panel.add-balance', $user->id) }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="number" step="any" name="amount" class="form-control" placeholder="Enter Amount">
            </div>

            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Reason of adding amount', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea class="form-control" name="reason"></textarea>
            </div>


            <button type="submit" class="btn btn-primary">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>

    <x-modal title="Subtruct Balance" id="subBalanceModal" size="">
        <form method="POST" action="{{ route('panel.sub-balance', $user->id) }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Amount', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="number" step="any" name="amount" class="form-control" placeholder="Enter Amount">
            </div>

            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Reason of subtruct amount', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea class="form-control" name="reason"></textarea>
            </div>


            <button type="submit" class="btn btn-primary">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>

    <x-modal title="Send Mail" id="sendMailModal">
        <form method="POST" action="{{ route('panel.send-mail', $user->id) }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }}</label>
                <input type="text" name="subject" class="form-control" placeholder="Enter Method Name">
            </div>
            <div class="mb-3">
                <label class="form-label">{{ tt_trans('Message', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea class="summernote" name="message"></textarea>
            </div>
            <button type="submit" class="btn btn-primary">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
        </form>
    </x-modal>


    <x-modal title="User profile settings" id="profileUpdateModal">
        <form method="POST" action="{{ route('panel.update-user-profile', $user->id) }}">
            @csrf
            <div class="row g-3">
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Phone', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <input type="text" name="mobile" class="form-control" placeholder="Enter Phone"
                        value="{{ $user->mobile }}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Address', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="address" class="form-control" placeholder="Enter address"
                        value="{{ $user->address?->address }}">
                </div>

                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('State', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="state" class="form-control" placeholder="Enter State"
                        value="{{ $user->address?->state }}">
                </div>

                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Zip', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="zip" class="form-control" placeholder="Enter Zip"
                        value="{{ $user->address?->zip }}">
                </div>

                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('City', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="city" class="form-control" placeholder="Enter City"
                        value="{{ $user->address?->city }}">
                </div>

                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Country', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="country" class="form-control" placeholder="Enter Country"
                        value="{{ $user->address?->country }}">
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>



    <x-modal id="withdrawDetailsModal" title="Withdraw Details" bodyId="append"></x-modal>
    <x-modal id="withdrawAcceptModal" size="" :isHeader="false">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <div class="card-icon-lg bg-light-success text-success text-2xl item-center rounded-circle">
                <iconify-icon icon="ph:seal-check-light"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Withdraw accept', cons()::LANGUAGE_BACKEND) }}</h5>
            <p>{{ tt_trans('Do you really wan to accept this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>

                <form  method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>
        </div>
    </x-modal>

    <x-modal id="withdrawRejectModal" size="" :isHeader="false">
        <h5 class="mb-1">{{ tt_trans('Reject this withdraw', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-warning text-sm">
            {{ tt_trans('Do you really wan to reject this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
        <form  method="post">
            @csrf
            <div class="mt-4">
                <label class="form-label">{{ tt_trans('Reason of reject', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea name="reason" class="form-control" rows="6" cols="12"></textarea>
            </div>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <button type="submit"
                    class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </form>
    </x-modal>
@endsection

@push('style')
    <link rel="stylesheet" href="{{ css('apexcharts.css', cons()::ASSETS_FROM_BACKEND) }}">
@endpush

@push('script')
    <script src="{{ js('apexcharts.min.js', cons()::ASSETS_FROM_BACKEND) }}"></script>

    <script>
        $(function() {
            'use strict'

            @if (count($finalDepositData) > 0 || count($finalWithdrawData) > 0)

                const depositData = @json($finalDepositData);
                const withdrawData = @json($finalWithdrawData);

                const dates = @json($dates);

                var options = {
                    series: [{
                            name: "Deposit",
                            data: depositData
                        },
                        {
                            name: "Withdraw",
                            data: withdrawData
                        }
                    ],
                    plotOptions: {
                        bar: {
                            columnWidth: '3%',
                        }
                    },
                    chart: {
                        toolbar: {
                            show: false
                        },
                        height: 375,
                        type: 'bar',
                        zoom: {
                            enabled: false
                        },
                        dropShadow: {
                            enabled: true,
                            enabledOnSeries: undefined,
                            top: 5,
                            left: 0,
                            blur: 3,
                            color: '#000',
                            opacity: 0.15
                        },
                    },
                    grid: {
                        borderColor: '#f1f1f1',
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        width: [2, 2],
                        curve: ['smooth', 'smooth'],
                        lineCap: 'butt',
                        dashArray: [0, 0]
                    },
                    title: {
                        text: undefined,
                    },
                    legend: {
                        show: true,
                        position: 'top',
                        horizontalAlign: 'center',
                        fontWeight: 600,
                        fontSize: '11px',
                        tooltipHoverFormatter: function(val, opts) {
                            return val + ' - ' + opts.w.globals.series[opts.seriesIndex][opts
                                    .dataPointIndex] +
                                ''
                        },
                        labels: {
                            colors: '#74767c',
                        },
                        markers: {
                            width: 7,
                            height: 7,
                            strokeWidth: 0,
                            radius: 12,
                            offsetX: 0,
                            offsetY: 0
                        },
                    },
                    markers: {
                        discrete: [{
                                seriesIndex: 0,
                                dataPointIndex: 5,
                                fillColor: '#305cfc',
                                strokeColor: '#fff',
                                size: 4,
                                shape: "circle"
                            },
                            {
                                seriesIndex: 0,
                                dataPointIndex: 11,
                                fillColor: '#305cfc',
                                strokeColor: '#fff',
                                size: 4,
                                shape: "circle"
                            },
                            {
                                seriesIndex: 1,
                                dataPointIndex: 10,
                                fillColor: '#23b7e5',
                                strokeColor: '#fff',
                                size: 4,
                                shape: "circle"
                            }, {
                                seriesIndex: 1,
                                dataPointIndex: 4,
                                fillColor: '#23b7e5',
                                strokeColor: '#fff',
                                size: 4,
                                shape: "circle"
                            }
                        ],
                        hover: {
                            sizeOffset: 6
                        }
                    },
                    yaxis: {
                        title: {
                            style: {
                                color: '#adb5be',
                                fontSize: '14px',
                                fontFamily: 'poppins, sans-serif',
                                fontWeight: 600,
                                cssClass: 'apexcharts-yaxis-label',
                            },
                        },
                        labels: {
                            formatter: function(y) {
                                return y.toFixed(0) + "";
                            },
                            show: true,
                            style: {
                                colors: "#8c9097",
                                fontSize: '11px',
                                fontWeight: 600,
                                cssClass: 'apexcharts-xaxis-label',
                            },
                        }
                    },
                    xaxis: {
                        type: 'day',
                        categories: dates,
                        axisBorder: {
                            show: true,
                            color: 'rgba(119, 119, 142, 0.05)',
                            offsetX: 0,
                            offsetY: 0,
                        },
                        axisTicks: {
                            show: true,
                            borderType: 'solid',
                            color: 'rgba(119, 119, 142, 0.05)',
                            width: 6,
                            offsetX: 0,
                            offsetY: 0
                        },
                        labels: {
                            rotate: -90,
                            style: {
                                colors: "#8c9097",
                                fontSize: '11px',
                                fontWeight: 600,
                                cssClass: 'apexcharts-xaxis-label',
                            },
                        }
                    },
                    tooltip: {
                        y: [{
                                title: {
                                    formatter: function(val) {
                                        return val
                                    }
                                }
                            },
                            {
                                title: {
                                    formatter: function(val) {
                                        return val
                                    }
                                }
                            },
                            {
                                title: {
                                    formatter: function(val) {
                                        return val;
                                    }
                                }
                            }
                        ]
                    },
                    colors: ["var(--primary)", "var(--info)"],
                };
                document.querySelector("#paymentOverview").innerHTML = " ";
                var chart1 = new ApexCharts(document.querySelector("#paymentOverview"), options);
                chart1.render();
            @endif



            $('.userstatus').on('change', function() {
                changeStatus('ability', 'status', "{{ $user->ability->id }}");
            })

            $('.kycstatus').on('change', function() {
                changeStatus('ability', 'kyc_verified', "{{ $user->ability->id }}");
            })

            $('.emailstatus').on('change', function() {
                changeStatus('ability', 'email_verified', "{{ $user->ability->id }}");
            })

            $('.smsstatus').on('change', function() {
                changeStatus('ability', 'sms_verified', "{{ $user->ability->id }}");
            })

            $('.details').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: $(this).data('action'),
                    success: function(response) {
                        $('#append').html(response)
                    }
                })
            })


            $('.details').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: "{{ route('panel.withdraw-details') }}",
                    data: {
                        withdraw: $(this).data('withdraw')
                    },
                    success: function(response) {
                        $('#append').html(response)
                    }
                })
            })

            $('.accept').on('click', function() {
                $('#withdrawAcceptModal').find('form').attr('action', $(this).data('action'))
            })

            $('.reject').on('click', function() {
                $('#withdrawRejectModal').find('form').attr('action', $(this).data('action'))
            })
        })
    </script>
@endpush

@push('style')
    <style>
        .no-data-wrapper {
            padding: 1.875rem 0;
            text-align: center;
        }

        @media (min-width: 576px) {
            .no-data-wrapper {
                padding: 3.125rem 0;
            }
        }

        .no-data-img {
            max-height: 150px;
        }

        @media (min-width: 576px) {
            .no-data-img {
                max-height: 250px;
            }
        }
    </style>
@endpush
