@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">

            <h4 class="card-title mb-0">
                {{ tt_trans(str_replace('_', ' ', ucwords(request()->sort) . ' Users'), cons()::LANGUAGE_BACKEND) }}</h4>

            <div class="d-flex flex-wrap align-items-center gap-2">
                <form class="d-flex align-items-center gap-2" method="GET">
                    <div class="position-relative">
                        <input type="text" name="name" class="form-control form-control-sm ps-35"
                            placeholder="{{tt_trans('Name / Email',cons()::LANGUAGE_BACKEND)}}" value="{{ request()->name }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>

                    @if (request()->has('name'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i>
                        <span>{{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>
                </form>
                <div class="dropdown dropdown-menu-end">
                    <button type="button" class="btn btn-sm btn-light" data-bs-toggle="dropdown">
                        <i class="ri-arrow-up-down-line"></i>
                        <span>{{ tt_trans('Sort', cons()::LANGUAGE_BACKEND) }}</span>
                    </button>
                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3" href="{{ route('panel.users') }}">
                                <span class="text-lg"><iconify-icon icon="heroicons:users"></iconify-icon></span>
                                <span>{{ tt_trans('All users', cons()::LANGUAGE_BACKEND) }}</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3"
                                href="{{ route('panel.users', ['sort' => 'active']) }}">
                                <span class="text-lg"><iconify-icon icon="hugeicons:user-check-02"></iconify-icon></span>
                                <span>{{ tt_trans('Active users', cons()::LANGUAGE_BACKEND) }}</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3"
                                href="{{ route('panel.users', ['sort' => 'deactive']) }}">
                                <span class="text-lg"><iconify-icon icon="mingcute:user-x-line"></iconify-icon></span>
                                <span>{{ tt_trans('Deactive users', cons()::LANGUAGE_BACKEND) }}</span>
                                <span class="badge badge-danger rounded-pill ms-auto">{{ $deactive }}</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3"
                                href="{{ route('panel.users', ['sort' => 'email_unverified']) }}">
                                <span class="text-lg"><iconify-icon icon="hugeicons:mail-remove-02"></iconify-icon></span>
                                <span>{{ tt_trans('Email unverified', cons()::LANGUAGE_BACKEND) }}</span>
                                <span class="badge badge-danger rounded-pill ms-auto">{{ $email_unverified }}</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3"
                                href="{{ route('panel.users', ['sort' => 'sms_unverified']) }}">
                                <span class="text-lg"><iconify-icon
                                        icon="material-symbols:sms-failed-outline"></iconify-icon></span>
                                <span>{{ tt_trans('SMS unverified', cons()::LANGUAGE_BACKEND) }}</span>
                                <span class="badge badge-danger rounded-pill ms-auto">{{ $sms_unverified }}</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-3"
                                href="{{ route('panel.users', ['sort' => 'kyc_unverified']) }}">
                                <span class="text-lg"><iconify-icon icon="octicon:unverified-24"></iconify-icon></span>
                                <span>{{ tt_trans('KYC unverified', cons()::LANGUAGE_BACKEND) }}</span>
                                <span class="badge badge-danger rounded-pill ms-auto">{{ $kyc_unverified }}</span>
                            </a>
                        </li>

                    </ul>
                </div>



                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#bulk">
                    <i class="ri-mail-send-line"></i>
                    <span>{{ tt_trans('Bulk Mail', cons()::LANGUAGE_BACKEND) }}</span>
                </button>
            </div>

        </div>
        <div class="card-body">
            <x-table :paginations="$users">
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>
                        {{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-profile-line"></i> {{ tt_trans('Balance', cons()::LANGUAGE_BACKEND) }}
                    </th>
                    <th scope="col"><i class="ri-calendar-2-line"></i>
                        {{ tt_trans('Join Date', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-user-follow-line"></i>
                        {{ tt_trans('Verified', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-calendar-schedule-line"></i>
                        {{ tt_trans('Last Login', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>
                <x-slot name="tablebody">
                    @forelse ($users as $user)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('user', $user->image) }}" alt="image" class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0"><a href="{{ route('panel.user.details', $user->id) }}"
                                                class="text-primary text-line-1 w-150px">{{ $user->full_name }}</a></h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted text-line-1 w-150px">
                                            {{ $user->email }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <p class="mb-0">{{ formatter($user->balance, true) }}</p>
                            </td>
                            <td>{{ dateFormatter($user->created_at) }}</td>
                            <td>
                                <div class="d-flex flex-wrap gap-1">
                                    <span
                                        class="badge badge-light-{{ $user->ability?->kyc_verified ? 'success' : 'danger' }}"
                                        data-bs-toggle="tooltip"
                                        data-bs-title="{{ $user->ability?->kyc_verified ? 'KYC verified' : 'KYC unverified' }}">

                                        @if ($user->ability?->kyc_verified)
                                            <i class="ri-check-double-line"></i>
                                        @else
                                            <i class="ri-question-line"></i>
                                        @endif

                                        {{ tt_trans('KYC', cons()::LANGUAGE_BACKEND) }}
                                    </span>
                                    <span
                                        class="badge badge-light-{{ $user->ability?->email_verified ? 'success' : 'danger' }}"
                                        data-bs-toggle="tooltip"
                                        data-bs-title="{{ $user->ability?->email_verified ? 'Email verified' : 'Email unverified' }}">
                                        @if ($user->ability?->email_verified)
                                            <i class="ri-check-double-line"></i>
                                        @else
                                            <i class="ri-question-line"></i>
                                        @endif
                                        {{ tt_trans('Email', cons()::LANGUAGE_BACKEND) }}
                                    </span>
                                    <span
                                        class="badge badge-light-{{ $user->ability?->sms_verified ? 'success' : 'danger' }}"
                                        data-bs-toggle="tooltip"
                                        data-bs-title="{{ $user->ability?->sms_verified ? 'SMS verified' : 'SMS unverified' }}">
                                        @if ($user->ability?->sms_verified)
                                            <i class="ri-check-double-line"></i>
                                        @else
                                            <i class="ri-question-line"></i>
                                        @endif
                                        {{ tt_trans('SMS', cons()::LANGUAGE_BACKEND) }}
                                    </span>
                                </div>
                            </td>
                            <td>{{ dateFormatter($user->last_login_at) }}</td>
                            <td>
                                <?= status($user->ability) ?>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="{{ route('panel.user.details', $user->id) }}"
                                        class="btn btn-icon rounded-circle btn-primary">
                                        <i class="ri-eye-line"></i>
                                    </a>
                                    <x-delete-button :action="route('panel.delete.user', $user->id)"></x-delete-button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>
            </x-table>
        </div>
    </div>

    <x-modal title="Send Bulk Mail" id="bulk">
        <form method="POST" action="{{ route('panel.bulk-mail') }}">
            @csrf
            <div class="row g-3">
                <div class="col-lg-12">
                    <label class="form-label">{{ tt_trans('Subject', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <input type="text" name="subject" class="form-control" placeholder="{{tt_trans('Enter Subject',cons()::LANGUAGE_BACKEND)}}">
                </div>
                <div class="col-lg-12">
                    <div class="d-flex flex-wrap align-items-center gap-3">
                        <label class="form-label">{{ tt_trans('User Type', cons()::LANGUAGE_BACKEND) }}</label>
                        <div class="form-check style-check">
                            <input class="form-check-input" type="checkbox" value="" id="selectAllCheckbox">
                            <label class="form-check-label text-sm" for="selectAllCheckbox">
                                {{ tt_trans('Select All', cons()::LANGUAGE_BACKEND) }}
                            </label>
                        </div>
                    </div>
                    <select name="types[]" id="mySelect" class="form-select-two form-select-two-tokenizer" multiple>
                        <option value="active">{{ tt_trans('Active', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="inactive">{{ tt_trans('Inactive', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="email_verified">{{ tt_trans('Email Verified', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="email_unverified">{{ tt_trans('Email Unverified', cons()::LANGUAGE_BACKEND) }}
                        </option>
                        <option value="sms_unverified">{{ tt_trans('SMS Unverified', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="sms_verified">{{ tt_trans('SMS Verified', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="kyc_verified">{{ tt_trans('KYC Verified', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="kyc_unverified">{{ tt_trans('KYC Unverified', cons()::LANGUAGE_BACKEND) }}</option>
                    </select>
                </div>
                <div class="col-12">
                    <label class="form-label">{{ tt_trans('Message', cons()::LANGUAGE_BACKEND) }} <sup
                            class="text-danger">*</sup></label>
                    <textarea class="summernote" name="message"></textarea>
                </div>
                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Submit', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {

            'use strict'

            $(".form-select-two-tokenizer").select2({
                tags: true,
                tokenSeparators: [',', ' ']
            })

            $('#selectAllCheckbox').on('click', function() {
                if ($(this).is(':checked')) {
                    $('#mySelect > option').prop('selected', true);
                    $('#mySelect').trigger('change');
                } else {
                    $('#mySelect > option').prop('selected', false);
                    $('#mySelect').trigger('change');
                }
            });
        })
    </script>
@endpush
