<li class="{{ empty($node['children']) ? '' : 'has-referral' }}">
    <div class="single-referral">
        <div class="user d-flex align-items-center gap-3">
            <img src="{{ getFile('user', $node['user']->image) }}" alt="image" class="avatar-3xl">
            <div class="content">
                <h6 class="mb-0">{{ $node['user']->full_name }}</h6>
                <p class="text-muted text-sm mb-0">{{ dateFormatter($node['user']->created_at) }}</p>
            </div>
        </div>

        <div class="amount">
            @if ($node['user']->id != $node['parent'])
                <p class="mb-0 text-sm">{{ tt_trans('Comission', cons()::LANGUAGE_BACKEND) }}</p>
            @else
                <p class="mb-0 text-sm">{{ tt_trans('Total Comission', cons()::LANGUAGE_BACKEND) }}</p>
            @endif

            @if ($node['user']->id != $node['parent'])
                <h4 class="mb-0">
                    {{ formatter($node['user']->giveAway($node['parent']), true) }}
                </h4>
            @else
                <h4 class="mb-0">{{ formatter($node['user']->myCommissions->sum('amount'), true) }}</h4>
            @endif
        </div>
        @if (!empty($node['children']))
            <button type="button" class="expand-btn">
            </button>
        @endif
    </div>

    <ul class="sub-referral-tree active">
        @if (!empty($node['children']))
            @foreach ($node['children'] as $childNode)
                @include('backend.users.tree', ['node' => $childNode])
            @endforeach
        @endif
    </ul>
</li>
