<ul class="list-group">
    <li class="list-group-item d-flex justify-content-between bg-light">
        <div>
            <h6 class="mb-0"><a href="{{route('panel.user.details',$withdraw->user_id)}}" class="text-sm text-primary text-break">{{$withdraw->user?->full_name}}</a>
            </h6>
            <p class="text-xs mb-0 line-height-1 mt-1 text-break">{{$withdraw->user?->email}}</p>
        </div>
        <div>
            <p class="mb-0 line-height-1 text-sm fw-semibold display-color">{{dateFormatter($withdraw->created_at)}}</p>
            <p class="mb-0 text-xs mt-1 text-break">{{tt_trans('Trx',cons()::LANGUAGE_BACKEND)}}: {{$withdraw->trx}}</p>
        </div>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Status',cons()::LANGUAGE_BACKEND)}}</span>
        <?= status($withdraw,'','deposit')?>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Withdraw Method',cons()::LANGUAGE_BACKEND)}}</span>
        <span class="badge badge-light-primary">{{$withdraw->method?->name}}</span>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Conversion Rate',cons()::LANGUAGE_BACKEND)}}</span>
        <span>1 {{tc()->get('currency')}} = {{$withdraw->rate.' '.$withdraw->method?->currency}}</span>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Amount',cons()::LANGUAGE_BACKEND)}}</span>
        <span>{{formatter($withdraw->withdraw_amount, true)}}</span>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Charge',cons()::LANGUAGE_BACKEND)}}</span>
        <span>{{formatter($withdraw->charge, true)}}</span>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between text-sm">
        <span>{{tt_trans('Getable Amount',cons()::LANGUAGE_BACKEND)}}</span>
        <span>{{formatter($withdraw->getable_amount, true)}}</span>
    </li>
    <li class="list-group-item d-flex align-items-center justify-content-between fw-semibold bg-light">
        <span>{{tt_trans('Amount in gateway currency',cons()::LANGUAGE_BACKEND)}}</span>
        <span>{{formatter($withdraw->getable_amount_in_method_currency).' '.$withdraw->method?->currency}}</span>
    </li>
</ul>

<div class="mt-4 border bg-light-light p-3 rounded-2">
    <label class="form-label">{{tt_trans('Note for withdraw',cons()::LANGUAGE_BACKEND)}}</label>
    <p class="mb-0">{{$withdraw->note}}</p>
</div>

@if($withdraw->status == cons()::REJECTED)
<div class="mt-4 border bg-light-danger p-3 rounded-2">
    <label class="form-label">{{tt_trans('Rejected Note for withdraw',cons()::LANGUAGE_BACKEND)}}</label>
    <p class="mb-0">{{$withdraw->reason}}</p>
</div>
@endif
