<form action="{{ route('panel.withdraw.update', $method->id) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="row g-3">
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw method name', cons()::LANGUAGE_BACKEND) }}</label>
            <input type="text" name="name" class="form-control" placeholder="Enter Method Name" value="{{$method->name}}">
        </div>
        
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw method Image', cons()::LANGUAGE_BACKEND) }}</label>
            <input type="file" name="image" class="form-control">
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Currency', cons()::LANGUAGE_BACKEND) }}</label>
            <input type="text" name="currency" class="form-control" placeholder="Enter Currency" value="{{$method->currency}}">
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Currency rate', cons()::LANGUAGE_BACKEND) }}</label>
            <div class="input-group">
                <span class="input-group-text text-sm" id="basic-addon2">1 {{ tc()->get('currency') }} = </span>
                <input type="text" class="form-control" name="rate" placeholder="Enter Rate" value="{{formatter($method->rate)}}">
            </div>
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw method charge type', cons()::LANGUAGE_BACKEND) }}</label>
            <select name="type" class="form-select">
                <option value="{{ cons()::FIXED }}" {{selectedOption($method->type == cons()::FIXED)}}>{{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                <option value="{{ cons()::PERCENTAGE }}" {{selectedOption($method->type == cons()::PERCENTAGE)}}>{{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}</option>
            </select>
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw method charge', cons()::LANGUAGE_BACKEND) }}</label>
            <div class="input-group">
                <input type="text" class="form-control" name="charge" placeholder="Enter Method Charge" value="{{formatter($method->charge)}}">
                <span class="input-group-text text-sm" id="basic-addon2">{{ tc()->get('currency') }}</span>
            </div>
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw min amount', cons()::LANGUAGE_BACKEND) }}</label>
            <input type="text" name="min_amount" class="form-control" placeholder="Enter Min Amount" value="{{formatter($method->min_amount)}}">
        </div>
        <div class="col-lg-6">
            <label class="form-label">{{ tt_trans('Withdraw max amount', cons()::LANGUAGE_BACKEND) }}</label>
            <input type="text" name="max_amount" class="form-control" placeholder="Enter Max Amount" value="{{formatter($method->max_amount)}}">
        </div>
        <div class="col-12">
            <label class="form-label">{{ tt_trans('Withdraw instruction', cons()::LANGUAGE_BACKEND) }}</label>
            <textarea class="summernote" name="instruction">
                <?= ($method->instruction) ?>
            </textarea>
        </div>
        <div class="col-12">
            <button type="submit" class="btn btn-primary">{{ tt_trans('Update', cons()::LANGUAGE_BACKEND) }}</button>
        </div>
    </div>
</form>
