@extends('backend.layouts.master')

@section('panel')
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-4">
        <h4 class="mb-0 h5">{{ tt_trans('All Withdraw Methods', cons()::LANGUAGE_BACKEND) }}</h4>
    </div>
    <div class="row g-3">
        @forelse ($methods as $method)
            <div class="col-xxl-3 col-lg-4 col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-wrap align-items-center gap-3">
                            <div class="card-icon-lg bg-primary text-2xl text-white item-center rounded-circle">
                                <img src="{{ getFile('withdraw', $method->image) }}" alt="image"
                                    class="w-100 h-100 object-fit-cover rounded-circle">
                            </div>
                            <div>
                                <h4 class="mb-0 h5">{{ $method->name }}</h4>
                                <?= status($method) ?>
                            </div>
                        </div>
                        <ul class="list-group mt-4 bg-white text-sm">
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Currency Method', cons()::LANGUAGE_BACKEND) }}</span>
                                <span class="text-primary">{{ $method->currency }}</span>
                            </li>
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Currency Rate', cons()::LANGUAGE_BACKEND) }}</span>
                                <span>1 {{ tc()->get('currency') }} =
                                    {{ formatter($method->rate) . ' ' . $method->currency }}</span>
                            </li>
                        </ul>

                        <ul class="list-group mt-3 bg-white text-sm">
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Charge Type', cons()::LANGUAGE_BACKEND) }}</span>
                                <span>
                                    {{ $method->type ? tt_trans('Fixed', cons()::LANGUAGE_BACKEND) : tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                                </span>
                            </li>
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</span>
                                <span>{{ formatter($method->charge, true) }}</span>
                            </li>
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Min Withdraw', cons()::LANGUAGE_BACKEND) }}</span>
                                <span>{{ formatter($method->min_amount, true) }}</span>
                            </li>
                            <li
                                class="list-group-item bg-extra-light d-flex align-items-center justify-content-between gap-2">
                                <span>{{ tt_trans('Max Withdraw', cons()::LANGUAGE_BACKEND) }}</span>
                                <span>{{ formatter($method->max_amount, true) }}</span>
                            </li>
                        </ul>
                        <div class="mt-3 row row-cols-2">
                            <div class="col">
                                <button type="button" class="btn btn-light-primary w-100 edit" data-bs-toggle="modal"
                                    data-bs-target="#edit" data-method="{{ $method->id }}"><i class="ri-edit-line"></i>
                                    {{ tt_trans('Edit', cons()::LANGUAGE_BACKEND) }}</button>
                            </div>
                            <div class="col">
                                <input class="toggle-one changeStatus" {{ $method->status ? 'checked' : '' }}
                                    data-method="{{ $method->id }}" type="checkbox" data-on="Active" data-off="Disable"
                                    data-onstyle="success" data-offstyle="danger" data-width="100%">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
        @endforelse

        <div class="col-xxl-3 col-lg-4 col-md-6">
            <div
                class="card p-3 py-4 border border-2 border-dashed border-light-primary position-relative h-100 d-flex justify-content-center align-items-center">
                <button type="button" class="position-absolute z-1 top-0 start-0 w-100 h-100" data-bs-toggle="modal"
                    data-bs-target="#add"></button>
                <div class=" d-flex flex-wrap align-items-center justify-content-center gap-3">
                    <span class="text-primary text-2xxl"><iconify-icon icon="mynaui:credit-card-plus"></iconify-icon></span>
                    <h6 class="mb-0 text-primary">{{ tt_trans('Add New Method', cons()::LANGUAGE_BACKEND) }}</h6>
                </div>
            </div>
        </div>
    </div>


    <x-modal id="add" title="Create new withdraw method">
        <form action="{{ route('panel.withdraw.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row g-3">
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Withdraw method name', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="name" class="form-control" placeholder="{{tt_trans('Enter Method Name',cons()::LANGUAGE_BACKEND)}}">
                </div>

                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Withdraw method Image', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="file" name="image" class="form-control">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Currency', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="currency" class="form-control" placeholder="{{tt_trans('Enter Currency',cons()::LANGUAGE_BACKEND)}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Currency rate', cons()::LANGUAGE_BACKEND) }}</label>
                    <div class="input-group">
                        <span class="input-group-text text-sm" id="basic-addon2">1 {{ tc()->get('currency') }} = </span>
                        <input type="text" class="form-control" name="rate" placeholder="{{tt_trans('Enter Rate',cons()::LANGUAGE_BACKEND)}}">
                    </div>
                </div>
                <div class="col-lg-6">
                    <label
                        class="form-label">{{ tt_trans('Withdraw method charge type', cons()::LANGUAGE_BACKEND) }}</label>
                    <select name="type" class="form-select">
                        <option value="{{ cons()::FIXED }}">{{ tt_trans('Fixed', cons()::LANGUAGE_BACKEND) }}</option>
                        <option value="{{ cons()::PERCENTAGE }}">{{ tt_trans('Percentage', cons()::LANGUAGE_BACKEND) }}
                        </option>
                    </select>
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Withdraw method charge', cons()::LANGUAGE_BACKEND) }}</label>
                    <div class="input-group">
                        <input type="text" class="form-control" name="charge" placeholder="{{tt_trans('Enter Method Charge',cons()::LANGUAGE_BACKEND)}}">
                        <span class="input-group-text text-sm" id="basic-addon2">{{ tc()->get('currency') }}</span>
                    </div>
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Withdraw min amount', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="min_amount" class="form-control" placeholder="{{tt_trans('Enter Min Amount',cons()::LANGUAGE_BACKEND)}}">
                </div>
                <div class="col-lg-6">
                    <label class="form-label">{{ tt_trans('Withdraw max amount', cons()::LANGUAGE_BACKEND) }}</label>
                    <input type="text" name="max_amount" class="form-control" placeholder="{{tt_trans('Enter Max Amount',cons()::LANGUAGE_BACKEND)}}">
                </div>
                <div class="col-12 summer-note-form">
                    <label class="form-label">{{ tt_trans('Withdraw instruction', cons()::LANGUAGE_BACKEND) }}</label>
                    <textarea class="summernote" name="instruction"></textarea>
                </div>
                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary">{{ tt_trans('Save', cons()::LANGUAGE_BACKEND) }}</button>
                </div>
            </div>
        </form>
    </x-modal>


    <x-modal id="edit" title="Update withdraw method" bodyId="append">

    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $('[data-toggle="dropdown"]').each(function() {
                $(this).attr('data-bs-toggle', 'dropdown');
                $(this).removeAttr('data-toggle');
            });

            $('.toggle-one').bootstrapToggle();

            $('.changeStatus').on('change', function() {
                changeStatus('Withdraw_method', 'status', $(this).data('method'));

                window.location.href = "{{ url()->current() }}"

            })

            $('.edit').on('click', function() {

                sendHttpRequest("POST", "{{ route('panel.method-fetch') }}", {
                    id: $(this).data('method'),
                    _token: "{{ csrf_token() }}"
                }, "#append")

            })
        })
    </script>
@endpush
