@extends('backend.layouts.master')

@section('panel')
    <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
            <h4 class="card-title mb-0">{{ tt_trans('All Withdraws', cons()::LANGUAGE_BACKEND) }}</h4>
            <form method="GET">
                <div class="d-flex flex-wrap align-items-center gap-2">
                    <div class="position-relative">
                        <input type="text" name="trx" class="form-control form-control-sm ps-35"
                            placeholder="{{ tt_trans('Search trx...', cons()::LANGUAGE_BACKEND) }}"
                            value="{{ request()->trx }}">
                        <span class="position-absolute top-middle start-10">
                            <i class="ri-search-line"></i>
                        </span>
                    </div>
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <div class="position-relative">
                            <input type="text" name="from" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{ tt_trans('MM/DD/YYYY', cons()::LANGUAGE_BACKEND) }}"
                                value="{{ request()->from }}">
                        </div>
                        <span>to</span>
                        <div class="position-relative">
                            <input type="text" name="to" class="form-control form-control-sm datepickerWithIcon"
                                autocomplete="off" placeholder="{{ tt_trans('MM/DD/YYYY', cons()::LANGUAGE_BACKEND) }}"
                                value="{{ request()->to }}">
                        </div>
                    </div>

                    @if (request()->has('trx') || request()->has('to') || request()->has('from'))
                        <a href="{{ url()->current() }}" class="btn btn-sm btn-outline-danger"><i
                                class="ri-close-large-line"></i>
                            {{ tt_trans('Clear Filter', cons()::LANGUAGE_BACKEND) }}</a>
                    @endif


                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="ri-filter-3-line"></i> {{ tt_trans('Filter', cons()::LANGUAGE_BACKEND) }}
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body">
            <x-table :paginations="$withdraw_requests">
                <tr>
                    <th scope="col"><i class="ri-account-circle-line"></i>
                        {{ tt_trans('User', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-calendar-2-line"></i>
                        {{ tt_trans('Date', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-secure-payment-line"></i>
                        {{ tt_trans('Gateway', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-wallet-2-line"></i>
                        {{ tt_trans('Withdraw Amount', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-wallet-2-line"></i>
                        {{ tt_trans('Charge', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-wallet-3-line"></i>
                        {{ tt_trans('Final Amount', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-checkbox-circle-line"></i>
                        {{ tt_trans('Status', cons()::LANGUAGE_BACKEND) }}</th>
                    <th scope="col"><i class="ri-arrow-right-up-line"></i>
                        {{ tt_trans('Action', cons()::LANGUAGE_BACKEND) }}</th>
                </tr>

                <x-slot name="tablebody">
                    @forelse ($withdraw_requests as $withdraw)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <img src="{{ getFile('user', $withdraw->user?->image) }}" alt="image"
                                        class="avatar-lg">
                                    <div>
                                        <h6 class="text-sm mb-0">
                                            <a href="{{ route('panel.user.details', $withdraw->user->id) }}"
                                                class="text-primary text-line-1 w-120px">{{ $withdraw->user->username }}</a>
                                        </h6>
                                        <p class="text-xs mt-1 mb-0 line-height-1 text-muted">
                                            {{ tt_trans('Trx', cons()::LANGUAGE_BACKEND) }}: {{ $withdraw->trx }}</p>
                                    </div>
                                </div>
                            </td>
                            <td>{{ dateFormatter($withdraw->created_at) }}</td>
                            <td>
                                <span class="badge badge-light-primary">{{ $withdraw->method->name }}</span>
                            </td>
                            <td>
                                {{ formatter($withdraw->withdraw_amount, true) }}
                            </td>
                            <td>
                                {{ formatter($withdraw->charge, true) }}
                            </td>
                            <td> {{ formatter($withdraw->getable_amount, true) }}</td>
                            <td>
                                <?= status($withdraw, '', 'deposit') ?>
                            </td>
                            <td>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <button class="btn btn-icon btn-primary rounded-circle details"
                                        data-withdraw="{{ $withdraw->id }}" data-bs-toggle="modal"
                                        data-bs-target="#withdrawDetailsModal">
                                        <i class="ri-eye-line"></i>
                                    </button>
                                    @if ($withdraw->status == cons()::PENDING)
                                        <button class="btn btn-icon btn-success rounded-circle accept"
                                            data-action="{{ route('panel.withdraw-accept', $withdraw->id) }}"
                                            data-bs-toggle="modal" data-bs-target="#withdrawAcceptModal">
                                            <i class="ri-check-line"></i>
                                        </button>
                                        <button class="btn btn-icon btn-danger rounded-circle reject"
                                            data-action="{{ route('panel.withdraw-reject', $withdraw->id) }}"
                                            data-bs-toggle="modal" data-bs-target="#withdrawRejectModal">
                                            <i class="ri-forbid-line"></i>
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <x-no-data></x-no-data>
                    @endforelse
                </x-slot>

            </x-table>

        </div>
    </div>

    <x-modal id="withdrawDetailsModal" title="Withdraw Details" bodyId="append"></x-modal>
    <x-modal id="withdrawAcceptModal" size="" :isHeader="false">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <div class="card-icon-lg bg-light-success text-success text-2xl item-center rounded-circle">
                <iconify-icon icon="ph:seal-check-light"></iconify-icon>
            </div>
            <h5 class="mt-4">{{ tt_trans('Withdraw accept', cons()::LANGUAGE_BACKEND) }}</h5>
            <p>{{ tt_trans('Do you really want to accept this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>

                <form method="post">
                    @csrf
                    <button type="submit"
                        class="btn btn-success">{{ tt_trans('Accept', cons()::LANGUAGE_BACKEND) }}</button>
                </form>
            </div>
        </div>
    </x-modal>

    <x-modal id="withdrawRejectModal" size="" :isHeader="false">
        <h5 class="mb-1">{{ tt_trans('Reject this withdraw', cons()::LANGUAGE_BACKEND) }}</h5>
        <p class="text-warning text-sm">
            {{ tt_trans('Do you really wan to reject this withdraw', cons()::LANGUAGE_BACKEND) }}?</p>
        <form method="post">
            @csrf
            <div class="mt-4">
                <label class="form-label">{{ tt_trans('Reason of reject', cons()::LANGUAGE_BACKEND) }}</label>
                <textarea name="reason" class="form-control" rows="6" cols="12"></textarea>
            </div>
            <div class="d-flex align-items-center gap-2 mt-4">
                <button type="button" class="btn btn-light"
                    data-bs-dismiss="modal">{{ tt_trans('Cancel', cons()::LANGUAGE_BACKEND) }}</button>
                <button type="submit" class="btn btn-danger">{{ tt_trans('Reject', cons()::LANGUAGE_BACKEND) }}</button>
            </div>
        </form>
    </x-modal>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict'

            $(".datepickerWithIcon").datepicker({
                showOn: "button",
                buttonImageOnly: false,
            });

            $('.details').on('click', function() {
                $.ajax({
                    method: "GET",
                    url: "{{ route('panel.withdraw-details') }}",
                    data: {
                        withdraw: $(this).data('withdraw')
                    },
                    success: function(response) {
                        $('#append').html(response)
                    }
                })
            })

            $('.accept').on('click', function() {
                $('#withdrawAcceptModal').find('form').attr('action', $(this).data('action'))
            })

            $('.reject').on('click', function() {
                $('#withdrawRejectModal').find('form').attr('action', $(this).data('action'))
            })
        })
    </script>
@endpush
