@props(['name' => '', 'target' => '', 'type' => 'text', 'value' => '', 'label' => ''])
@if (tc()->get('ai_status'))
    <div class="d-flex justify-content-between flex-wrap align-items-center mb-2">
        <label class="form-label ">{{ tt_trans($label) }}</label>
        <button class="text-primary text-xs d-inline-flex align-items-center gap-1 aigenerator" type="button"
            data-output="{{ $target }}" data-bs-target="#aimodal" data-bs-toggle="modal">
            <span class="text-lg line-height-1">
                <iconify-icon icon="mdi:magic" class="sidebar-menu-icon"></iconify-icon>
            </span>
            {{ tt_trans('Generate With AI', cons()::LANGUAGE_BACKEND) }}
        </button>
    </div>

    @if ($type == 'text')
        <input type="text" class="form-control" id="{{ $target }}" name="{{ $name }}"
            value="{{ $value }}">
    @elseif($type == 'textarea')
        <textarea name="{{ $name }}" class="form-control" id="{{ $target }}" cols="30" rows="3"
            required>{{ $value }}</textarea>
    @endif

    @if ($type == 'editor')
        @if ($value)
            @php
                $value = json_decode(json_encode($value), true);
            @endphp
        @endif
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <button class="nav-link active" id="english" data-bs-toggle="tab" data-bs-target="#english_editor"
                    type="button" role="tab" aria-controls="english_editor" aria-selected="true">
                    {{ tt_trans('English', cons()::LANGUAGE_BACKEND) }}
                </button>

                @foreach (languages() as $language)
                    <button class="nav-link" id="{{ $language->name }}" data-bs-toggle="tab"
                        data-bs-target="#{{ $language->name . '-' . $language->id }}" type="button" role="tab"
                        aria-controls="{{ $language->name . '-' . $language->id }}"
                        aria-selected="true">{{ $language->name }}</button>
                @endforeach
            </div>
        </nav>

        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade summer-note-form show active" id="english_editor" role="tabpanel"
                aria-labelledby="english_editor-tab" tabindex="0">
                <textarea name="{{ $name }}[en][description]" class="form-control summernote" id="{{ $target }}"
                    cols="30" rows="3">{{ $value ? $value['en']['description'] : '' }}</textarea>
            </div>
            @foreach (languages() as $language)
                <div class="tab-pane summer-note-form fade " id="{{ $language->name . '-' . $language->id }}"
                    role="tabpanel" aria-labelledby="{{ $language->name . '-' . $language->id }}-tab" tabindex="0">
                    @if (isset($value[$language->code]))
                        <textarea name="{{ $name }}[{{ $language->code }}][description]" class="form-control summernote"
                            cols="30" rows="3">{{ $value ? $value[$language->code]['description'] : '' }}</textarea>
                    @else
                        <textarea name="{{ $name }}[{{ $language->code }}][description]" class="form-control summernote"
                            cols="30" rows="3"></textarea>
                    @endif
                </div>
            @endforeach
        </div>
    @endif
@else
    <label class="form-label ">{{ tt_trans($label) }}</label>

    @if ($type == 'text')
        <input type="text" class="form-control" id="{{ $target }}" name="{{ $name }}"
            value="{{ $value }}">
    @elseif($type == 'textarea')
        <textarea name="{{ $name }}" class="form-control" id="{{ $target }}" cols="30" rows="3"
            required>{{ $value }}</textarea>
    @elseif($type == 'editor')
        @if ($value)
            @php
                $value = json_decode(json_encode($value), true);
            @endphp
        @endif

        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <button class="nav-link active" id="english" data-bs-toggle="tab" data-bs-target="#english_editor"
                    type="button" role="tab" aria-controls="english_editor"
                    aria-selected="true">{{ tt_trans('English', cons()::LANGUAGE_BACKEND) }}</button>

                @foreach (languages() as $language)
                    <button class="nav-link" id="{{ $language->name }}" data-bs-toggle="tab"
                        data-bs-target="#{{ $language->name . '-' . $language->id }}" type="button" role="tab"
                        aria-controls="{{ $language->name . '-' . $language->id }}"
                        aria-selected="true">{{ $language->name }}</button>
                @endforeach
            </div>
        </nav>
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade summer-note-form show active" id="english_editor" role="tabpanel"
                aria-labelledby="english_editor-tab" tabindex="0">
                <textarea name="{{ $name }}[en][description]" class="form-control summernote" id="{{ $target }}"
                    cols="30" rows="3">{{ $value ? $value['en']['description'] : '' }}</textarea>
            </div>
            @foreach (languages() as $language)
                <div class="tab-pane summer-note-form fade " id="{{ $language->name . '-' . $language->id }}"
                    role="tabpanel" aria-labelledby="{{ $language->name . '-' . $language->id }}-tab"
                    tabindex="0">
                    @if (isset($value[$language->code]))
                        <textarea name="{{ $name }}[{{ $language->code }}][description]" class="form-control summernote"
                            cols="30" rows="3">{{ $value ? $value[$language->code]['description'] : '' }}</textarea>
                    @else
                        <textarea name="{{ $name }}[{{ $language->code }}][description]" class="form-control summernote"
                            cols="30" rows="3"></textarea>
                    @endif
                </div>
            @endforeach
        </div>
    @endif
@endif
