<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href=" {{ css('remixicon.css') }}">
    <link rel="stylesheet" href="{{ css('all.min.css') }}">
    <link rel="stylesheet" href="{{ css('bootstrap-icons.min.css') }}">
    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">

    <style>
        .error-page {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3.125rem 0;
        }

        .erorr-numbers {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.9375rem;
        }

        @media (min-width: 576px) {
            .erorr-numbers {
                gap: 1.875rem;
            }
        }

        .erorr-numbers .erorr-number {
            font-size: 6.25rem;
            font-weight: 700;
            line-height: 1;
            color: var(--primary);
            text-shadow: 6px 2px var(--secondary);
        }

        @media (min-width: 576px) {
            .erorr-numbers .erorr-number {
                font-size: 9.375rem;
            }
        }

        @media (min-width: 1200px) {
            .erorr-numbers .erorr-number {
                font-size: 11.25rem;
            }
        }

        .erorr-numbers .erorr-number-first {
            transform: rotateZ(340deg);
        }

        .erorr-numbers .erorr-number-third {
            transform: rotateZ(-340deg);
            margin-top: -1.25rem;
        }

        @media (min-width: 576px) {
            .erorr-numbers .erorr-number-third {
                margin-top: -1.5625rem;
            }
        }

        @media (min-width: 1200px) {
            .erorr-numbers .erorr-number-third {
                margin-top: -2.1875rem;
            }
        }

        .erorr-numbers .erorr-number-second {
            position: relative;
            font-size: 6.25rem;
            margin-top: -20px;
        }

        @media (min-width: 576px) {
            .erorr-numbers .erorr-number-second {
                font-size: 7.5rem;
            }
        }

        @media (min-width: 1200px) {
            .erorr-numbers .erorr-number-second {
                font-size: 9.375rem;
            }
        }

        .erorr-numbers .erorr-number-second::before {
            position: absolute;
            content: "";
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--secondary);
            border-radius: 50%;
            z-index: -1;
        }
    </style>



     @if(isInstalled())
     
         <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">

        <title>{{ tc()->get('sitename') }}</title>


        @php
            $themeSettings = \App\Models\Theme::active()->first();
        @endphp
        <style>
            :root {
                --display-font: <?=$themeSettings?->heading_font_family ?>;
                --body-font: <?=$themeSettings?->paragraph_font_family ?>;
                --primary: <?=$themeSettings?->primary_color ?? '#FF6D13' ?>;
                --primary-two: <?=$themeSettings?->secondary_color ?? '#c3b72a' ?>;

            }
        </style>
        
        @endif
</head>

<body>


    <main id="main-container">
        <div class="error-page">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="text-center">
                            <div class="erorr-numbers">
                                <div class="erorr-number erorr-number-first">5</div>
                                <div class="erorr-number erorr-number-second">
                                    <i class="fa-solid fa-face-frown"></i>
                                </div>
                                <div class="erorr-number erorr-number-third">0</div>
                            </div>
                            <h3 class="mt-4">{{ __('HTTP Version Not Supported') }}</h3>
                            <p>{{ __('Indicates that the server does not support or refuses to support the major version of
                                                                                        HTTP specified in the request message.') }}
                            </p>
                            <a href="{{ route('home') }}" class="btn btn-primary mt-2"><i
                                    class="ri-arrow-left-line"></i> Back to
                                {{ __('Home') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ js('bootstrap.bundle.min.js') }}"></script>

    <script>
        $(function() {
            'use strict'
            $(".it-preloader-holder").delay(300).animate({
                "opacity": "0"
            }, 300, function() {
                $(".it-preloader-holder").css("display", "none");
            });
        });
    </script>

</body>

</html>
