@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header text-center">
                        <h4 class="card-title mb-0">{{ tt_front('Buy Token') }}</h4>
                    </div>
                    <div class="card-body p-4">
                        <div class=" d-flex justify-content-between">
                            <p>{{ tt_front('Seller') }}</p>
                            <p>{{ $auction->user->fullname }}</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <p>{{ tt_front('Available Token') }}</p>
                            <p>{{ $auction->availableToken() }} {{ $setting->token_symbol }}</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <p>{{ tt_front('Base Price') }}</p>
                            <p>{{ symbol($auction->token_base_price) }}</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <p>{{ tt_front('End Date') }}</p>
                            <p>{{ dateFormatter($auction->end_date) }}</p>
                        </div>

                        <form action="{{ route('auction.buy.token', $auction->trx) }}" method="post">
                            @csrf

                            <div class="form-group">
                                <label class="form-label">{{ tt_front('Token') }}</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="token" required>
                                    <span
                                        class="input-group-text bg-primary text-white">{{ $setting->token_symbol }}</span>
                                </div>
                            </div>

                            <div class="mt-3">
                                <button type="submit"
                                    class="btn btn-primary-gradient w-100">{{ tt_front('Buy Token') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="message-chat-wrapper">
                        <div class="message-chat-wrapper-header">

                        </div>
                        <div class="message-chat-wrapper-body scroll-y">

                        </div>
                        <div class="message-chat-wrapper-footer">
                            <div class="chatting-form">
                                <textarea name="message" cols="6" rows="3" class="form-control"
                                    placeholder="{{ tt_front('Write Message') }}..."></textarea>
                                <button type="submit" class="btn btn-sm btn-primary reply-btn"><i
                                        class="ri-reply-line"></i>
                                    {{ tt_front('Send') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script src="{{ js('messages.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>

    <script>
        'use strict';

        function loadOldMessages(userOne, userTwo) {
            $.ajax({
                url: "{{ route('message.old') }}",
                type: "GET",
                data: {
                    user_one: userOne,
                    user_two: userTwo
                },
                success: function(response) {
                    if (response.status === 'success') {
                        $(".message-chat-wrapper-header").html(`${response.data.header}`);
                        $(".message-chat-wrapper-body").html(`${response.data.body}`);
                    }
                },
                error: function(xhr) {
                    console.error('Error:', xhr.responseJSON.message || 'An error occurred.');
                }
            })
        }

        function sendMessage(sender, receiver, message) {

            $.ajax({
                url: "{{ route('message.send') }}",
                type: "POST",
                data: {
                    message: message,
                    _token: "{{ csrf_token() }}",
                    receiver_id: receiver
                },
                success: function(response) {
                    if (response.status === 'success') {
                        $("textarea[name=message]").val('');
                        loadOldMessages(sender, receiver);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let errorMessages = Object.values(errors).map(error => error[0]);


                        $.toast({
                            text: `<i class='fa-solid fa-circle-exclamation'></i> ${errorMessages}`,
                            showHideTransition: 'slide',
                            bgColor: 'var(--warning)',
                            textColor: '#fff',
                            allowToastClose: true,
                            hideAfter: 3000,
                            stack: 5,
                            textAlign: 'left',
                            position: 'top-right'
                        });


                    } else {
                        console.error('Error:', xhr.responseJSON.message || 'An error occurred.');
                    }
                }
            })
        }

        $(".reply-btn").on('click', function() {
            var message = $("textarea[name=message]").val();
            sendMessage("{{ user()->id }}", "{{ $auction->user->id }}", message)
        })

        loadOldMessages("{{ user()->id }}", "{{ $auction->user->id }}");
    </script>
@endpush
