@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-6">
                <div class="card">
                    <div class="card-header d-flex flex-wrap align-items-center justify-content-between">
                        <h4 class="card-title mb-0">{{ tt_front('Create Auction') }}</h4>
                        <p class="mb-0 d-inline-flex align-items-center gap-2">
                            <span class="text-primary text-lg">{{ user()->token }} {{ $setting->token_symbol ?? "" }}</span>
                            {{ tt_front('available') }}
                        </p>
                    </div>
                    <div class="card-body p-4">
                        <form action="{{ route('auction.store') }}" method="post">
                            @csrf
                            <div class="row gy-4">
                                <div class="col-lg-12">
                                    <label class="form-label">{{ tt_front('Token') }}</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="tokens" required>
                                        <span class="input-group-text bg-primary text-white">{{ $setting->token_symbol ?? "" }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <label class="form-label">{{ tt_front('Expected Profit Amount') }}</label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="expected_profit_percentage"
                                            class="form-control">
                                        <span class="input-group-text bg-primary text-white px-3">%</span>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <label class="form-label">{{ tt_front('End Date') }}</label>
                                    <div class="icon-field">
                                        <input type="text" name="end_date" class="form-control datepicker"
                                            autocomplete="off">
                                        <span class="icon"><i class="ri-calendar-2-line"></i></span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                                        <p class="text-muted mb-0">{{ tt_front('Current stage base price ') }}
                                        {{ symbol(getActiveStage()['stage']->base_price ?? 0) }}</p>

                                        <p class="mb-0 profit-text">{{ tt_front('Total coin price will be') }}: <span class="text-white">{{ symbol(getActiveStage()['stage']->base_price ?? 0 * user()->token) }}</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary-gradient w-100">{{ tt_front('Auction Submit') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';

        $(".datepicker").datepicker();

        $('input[name=expected_profit_percentage]').on('input', function() {
            let val = $(this).val();
            let basePrice = parseFloat("{{ getActiveStage()['stage']->base_price ?? 0 }}");
            let token = $("input[name=tokens]").val();
            let profitPerPrice = ((basePrice * val) / 100) + basePrice;
            let profitAmount = token * profitPerPrice;
            let currency = "{{ tc()->get('currency') }}";
            $('.profit-text').text(`Total coin price will be ${profitAmount.toFixed(2)} ${currency}`)
        });

        $("input[name=tokens]").on('input', function() {
            let val = $(this).val();
            let basePrice = parseFloat("{{ getActiveStage()['stage']->base_price ?? 0 }}");
            let percentage = +$("input[name=expected_profit_percentage]").val() ?? 0;
            let profitPerPrice = ((basePrice * percentage) / 100) + basePrice;
            let profitAmount = val * profitPerPrice;
            let currency = "{{ tc()->get('currency') }}";
            $('.profit-text').text(`Total coin price will be ${profitAmount.toFixed(2)} ${currency}`)
        });
    </script>
@endpush
