@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_front('My Auctions') }}</h4>

                <form class="d-flex flex-wrap gap-2">
                    <div>
                        <input type="text" name="trx" class="form-control form-control-md" autocomplete="off"
                            placeholder="{{ tt_front('Trx....') }}">

                    </div>
                    <select class="form-select form-select-md w-auto" name="status">
                        <option value="">{{ tt_front('Select Status') }}</option>
                        <option value="{{ cons()::RUNNING_AUCTION }}">{{ tt_front('Running') }}</option>
                        <option value="{{ cons()::WITHDRAW_AUCTION }}">{{ tt_front('Withdrawn') }}</option>
                        <option value="{{ cons()::COMPLETED_AUCTION }}">{{ tt_front('Completed') }}</option>
                    </select>
                    <button type="submit" class="btn btn-md btn-primary-gradient">{{ tt_front('Search') }}</button>
                </form>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table default-table head-light-bg responsive-table mb-0 radius-lg">
                        <thead>
                            <tr>
                                <th>{{ tt_front('SL') }}</th>
                                <th>{{ tt_front('Token Quantity') }}</th>
                                <th>{{ tt_front('Expected Profit') }}</th>
                                <th>{{ tt_front('Total Price') }}</th>
                                <th>{{ tt_front('Status') }}</th>
                                <th>{{ tt_front('End Date') }}</th>
                                <th>{{ tt_front('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($auctions as $auction)
                                <tr>
                                    <td>
                                        <span class="fw-semibold">{{ $auction->trx }}</span>
                                    </td>
                                    <td>{{ $auction->tokens }} {{ $setting->token_symbol ?? "" }}</td>
                                    <td>{{ $auction->expected_profit_percentage }}%</td>
                                    <td>{{ symbol($auction->tokens * $auction->token_base_price) }}</td>
                                    <td>
                                        @if ($auction->status == cons()::ACTIVE)
                                            <span class="badge badge-light-info">{{ tt_front('Running') }}</span>
                                        @elseif($auction->status == cons()::WITHDRAW_AUCTION)
                                            <span class="badge badge-light-warning">{{ tt_front('Withdrawn') }}</span>
                                        @elseif($auction->status == cons()::COMPLETED_AUCTION)
                                            <span class="badge badge-light-success">{{ tt_front('Completed') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <h6 class="mb-0 text-sm">{{ dateFormatter($auction->end_date, 'd M Y') }}</h6>
                                        <p class="mb-0">{{ dateFormatter($auction->end_date, 'H:i') }}</p>
                                    </td>
                                    <td>
                                        @if ($auction->status == cons()::ACTIVE)
                                            <button data-action="{{ route('auction.withdraw', $auction->trx) }}"
                                                class="btn btn-sm btn-danger flex-grow-1 withdraw-btn">
                                                {{ tt_front('Withdraw') }}
                                                <i class="ri-arrow-right-up-line"></i>
                                            </button>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">
                                        <div class="no-data-wrapper">
                                            <div class="w-100">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-6 text-center">
                                                        <img src="{{ getFile('constant_image', 'no-data-found.png') }}"
                                                            alt="image" class="no-data-wrapper-img">
                                                        <p class="mt-4 mb-0 text-md">{{ tt_front('No auction found') }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>


            @if ($auctions->hasPages())
                <div class="card-footer">
                    {{ $auctions->links() }}
                </div>
            @endif
        </div>
    </div>

    <div class="modal fade" id="withdrawModal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="post">
                    @csrf
                    <div class="modal-header">
                        <h1 class="modal-title mb-0" id="userImageModalLabel">{{ tt_front('Withdraw Auction') }}</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <p class="my-3">{{ tt_front('Are you sure to withdraw ') }} ?</p>
                        @if($setting)
                        <small>{{ tt_front("If you withdraw this auction  $setting->auction_refund_percentage % of the tokens will be deducted") }}</small>
                        @endif
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="submit" class="btn btn-md btn-danger rounded">{{ tt_front('Withdraw Now') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection




@push('script')
    <script>
        $(function() {

            'use strict';

            $('.withdraw-btn').on('click', function() {
                let modal = $("#withdrawModal");
                modal.find('form').attr('action', $(this).data('action'));
                modal.modal('show');
            });
        });
    </script>
@endpush
