@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_front('Available Auctions') }}</h4>
                <form class="d-flex flex-wrap gap-2">
                    <div class="icon-field">
                        <input type="text" name="seller" class="form-control form-control-md"
                            placeholder="Search seller name" value="{{ request()->seller }}">
                        <span class="icon"><i class="ri-account-circle-line"></i></span>
                    </div>
                    <div class="icon-field">
                        <input type="text" name="to" class="form-control datepicker form-control-md"
                            autocomplete="off" placeholder="" value="{{ request()->to }}">
                        <span class="icon"><i class="ri-calendar-2-line"></i></span>
                    </div>
                    <button type="submit" class="btn btn-md btn-primary-gradient">Search</button>
                </form>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table default-table head-light-bg responsive-table mb-0 radius-lg">
                        <thead>
                            <tr>
                                <th>{{ tt_front('SL') }}</th>
                                <th>{{ tt_front('Seller') }}</th>
                                <th>{{ tt_front('End Date') }}</th>
                                <th>{{ tt_front('Quantity') }}</th>
                                <th>{{ tt_front('Total Price') }}</th>
                                <th>{{ tt_front('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($auctions as $auction)
                                <tr>
                                    <td>
                                        <span class="fw-semibold">{{ $loop->iteration }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ getFile('user', $auction->user->image) }}"
                                                class="avatar-lg object-fit-cover rounded-circle flex-shrink-0"
                                                alt="image">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0 text-sm">{{ $auction->user->fullname }}</h6>
                                                <p class="mb-0">{{ $auction->user->email }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <h6 class="mb-0 text-sm">{{ dateFormatter($auction->end_date, 'd M Y') }}</h6>
                                        <p class="mb-0">{{ dateFormatter($auction->end_date, 'H:I') }}</p>
                                    </td>
                                    <td>
                                        <p class="mb-0">{{ $auction->availableToken() }} {{ $setting->token_symbol }}
                                        </p>
                                    </td>
                                    <td>
                                        <p class="mb-0">
                                            {{ symbol($auction->token_base_price * $auction->availableToken()) }}</p>
                                    </td>
                                    <td>
                                        <a href="{{ route('auction.buy', $auction->trx) }}"
                                            class="btn btn-sm btn-primary-gradient flex-grow-1">
                                            {{ tt_front('Buy Now') }}
                                            <i class="bi bi-arrow-up-right"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">
                                        <div class="no-data-wrapper">
                                            <div class="w-100">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-6 text-center">
                                                        <img src="{{ getFile('constant_image', 'no-data-found.png') }}"
                                                            alt="image" class="no-data-wrapper-img">
                                                        <p class="mt-4 mb-0 text-md">{{ tt_front('No auction found.') }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>


            @if ($auctions->hasPages())
                <div class="card-footer">
                    {{ $auctions->links() }}
                </div>
            @endif

        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {

            'use strict';
            $('.datepicker').datepicker();
        });
    </script>
@endpush
