@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_front('Purchase Auctions') }}</h4>
                <form class="d-flex flex-wrap gap-2">
                    <div class="icon-field">
                        <input type="text" name="trx" class="form-control form-control-md" placeholder="Trx..."
                            value="{{ request()->trx }}">
                        <span class="icon"><i class="ri-account-circle-line"></i></span>
                    </div>
                    <div class="icon-field">
                        <input type="text" name="to" class="form-control datepicker form-control-md"
                            autocomplete="off" placeholder="" value="{{ request()->to }}">
                        <span class="icon"><i class="ri-calendar-2-line"></i></span>
                    </div>
                    <button type="submit" class="btn btn-md btn-primary-gradient">Search</button>
                </form>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table default-table head-light-bg responsive-table mb-0 radius-lg">
                        <thead>
                            <tr>
                                <th>{{ tt_front('Seller') }}</th>
                                <th>{{ tt_front('Trx') }}</th>
                                <th>{{ tt_front('Purchase Date') }}</th>
                                <th>{{ tt_front('Quantity') }}</th>
                                <th>{{ tt_front('Total Price') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($purchases as $purchase)
                                <tr>

                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ getFile('user', $purchase->seller->image) }}"
                                                class="avatar-lg object-fit-cover rounded-circle flex-shrink-0"
                                                alt="image">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0 text-sm">{{ $purchase->seller->fullname }}</h6>
                                                <p class="mb-0">{{ $purchase->seller->email }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="fw-semibold">{{ $purchase->trx }}</span>
                                    </td>
                                    <td>
                                        <h6 class="mb-0 text-sm">{{ dateFormatter($purchase->created_at, 'd M Y') }}</h6>
                                        <p class="mb-0">{{ dateFormatter($purchase->created_at, 'H:I') }}</p>
                                    </td>
                                    <td>
                                        <p class="mb-0">{{ $purchase->tokens }} {{ $setting->token_symbol }}
                                        </p>
                                    </td>
                                    <td>
                                        <p class="mb-0">
                                            {{ symbol($purchase->total_price) }}</p>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">
                                        <div class="no-data-wrapper">
                                            <div class="w-100">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-6 text-center">
                                                        <img src="{{ getFile('constant_image', 'no-data-found.png') }}"
                                                            alt="image" class="no-data-wrapper-img">
                                                        <p class="mt-4 mb-0 text-md">{{ tt_front('No purchase found.') }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(function() {
            'use strict';

            $('.datepicker').datepicker();
        });
    </script>
@endpush
