<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>{{ tc()->get('sitename') }}</title>

    <link rel="icon" type="image/png" href="{{ getFile('icon', $themeSettings->icon) }}" sizes="16x16">


    @include('frontend::partials.header-style')

</head>

<body>

    <x-preloader></x-preloader>

    <div class="cursor"></div>
    <div class="cursor-follower"></div>

    <button type="button" class="top-action-btn">
        <span class="icon">
            <iconify-icon icon="ci:arrow-up-lg"></iconify-icon>
        </span>
        <span class="caption">{{ tt_front('Top') }}</span>
    </button>


    <main id="main-container">

        @include('frontend::partials.header')

        <?= bannerOrBreadcrumb() ?>

        <div id="liveAlertPlaceholder">
        </div>

        <div class="it-auth it-section-pt it-section-pb">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="it-auth-thumb">
                            <img src="{{ getFile('cms', cms('auth', 'image')) }}" alt="image">
                        </div>
                    </div>
                    <div class="col-lg-6 ps-xxl-5">
                        @yield('content')
                    </div>
                </div>
            </div>

            <img src="{{ getFile('constant_image', 'left-star.png') }}" alt="image" class="it-auth-left-star">
            <img src="{{ getFile('constant_image', 'right-star.png') }}" alt="image" class="it-auth-right-star">

            <img src="{{ getFile('constant_image', 'shape-left.png') }}" alt="image" class="it-auth-left-shape">
            <img src="{{ getFile('constant_image', 'shape-right.png') }}" alt="image" class="it-auth-right-shape">
        </div>

        @include('frontend::partials.footer')
    </main>







    @if (tc()->get('cookie_status'))
        @include('frontend::partials.cookie')
    @endif

    @include('frontend::partials.footer-script')
</body>

</html>
