@extends('frontend::auth.auth_master')
@section('content')

    <div class="it-auth-content">
        <div class="text-center mb-4">
            <h3>{{ cms('auth', 'forget_password_title') }}</h3>
            <div class="mb-4 text-center">
                <h3>{{ tt_front('Recover Password') }}</h3>
                <p>{{ tt_front('Reset your password by verifying your email or phone to regain account access') }}
                </p>
            </div>
        </div>
        <form method="POST">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_front('Email') }}</label>
                <div class="icon-field">
                    <input type="email" name="email" class="form-control" placeholder="Enter Email Address">
                    <span class="icon"><i class="fa-regular fa-envelope"></i></span>
                </div>
            </div>

            <x-recaptcha></x-recaptcha>

            <button type="submit" class="btn btn-primary-gradient w-100">{{ tt_front('Send verification code') }}</button>
        </form>
    </div>
@endsection
