@extends('frontend::auth.auth_master')
@section('content')

    <div class="it-auth-content">
        <div class="text-center mb-4">
            <h3>{{ cms('auth', 'login_title') }}</h3>
            <p class="mb-0">{{ tt_front("Don't have an account?") }} <a href="{{ route('registration') }}"
                    class="text-primary">{{ tt_front('Register') }}</a></p>
        </div>
        <form method="post">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ tt_front('Email') }}</label>
                <div class="icon-field">
                    <input type="email" name="email" class="form-control"
                        placeholder="{{ tt_front('Enter Email Address') }}">
                    <span class="icon"><i class="bi bi-envelope"></i></span>
                </div>
            </div>
            <div class="mb-2">
                <label class="form-label">{{ tt_front('Password') }}</label>
                <div class="password-field icon-field">
                    <input type="password" name="password" id="passField" class="form-control"
                        placeholder="{{ tt_front('Enter Password') }}">
                    <span class="icon"><i class="bi bi-lock"></i></span>
                    <button type="button" class="password-field-btn">
                        <span class="eye-one"><i class="ri-eye-line"></i></span>
                        <span class="eye-off"><i class="ri-eye-off-line"></i></span>
                    </button>
                </div>
            </div>
            <div class="text-end mb-3">
                <a href="{{ route('forget-password') }}"
                    class="text-primary text-sm fw-medium">{{ tt_front('Forget Password') }} ?</a>
            </div>
            <button type="submit" class="btn btn-primary-gradient w-100">{{ tt_front('Login') }}</button>


            @if (tc()->get('facebook_status') || tc()->get('google_status'))
                <div class="or-divider mt-4 mb-3">
                    <span>{{ tt_front('or') }}</span>
                </div>

                <div class="d-flex align-items-center gap-2">
                    @if (tc()->get('facebook_status'))
                        <a href="{{ route('facebook.redirect') }}" class="btn btn-outline-light shadow-none flex-grow-1">
                            <i class="fa-brands fa-facebook"></i>
                            <span>{{ tt_front('Facebook') }}</span>
                        </a>
                    @endif
                    @if (tc()->get('google_status'))
                        <a href="{{ route('google.redirect') }}" class="btn btn-outline-light shadow-none flex-grow-1">
                            <i class="fa-brands fa-google"></i>
                            <span>{{ tt_front('Google') }}</span>
                        </a>
                    @endif
                </div>
            @endif
        </form>
    </div>
@endsection
