@extends('frontend::auth.auth_master')
@section('content')

    <div class="it-auth-content">
        <div class="text-center mb-4">
            <h3>{{ cms('auth', 'register_title') }}</h3>
            <p class="mb-0">{{ tt_front('Have an account') }} ? <a href="{{ route('login') }}"
                    class="text-primary">{{ tt_front('Login') }}</a></p>
        </div>
        <form method="post">
            @csrf
            <div class="row gy-4">
                <div class="col-md-6">
                    <label class="form-label">{{ tt_front('First Name') }}</label>
                    <div class="icon-field">
                        <input type="text" name="f_name" class="form-control"
                            placeholder="{{ tt_front('Enter First Name') }}" autocomplete="off">
                        <span class="icon"><i class="bi bi-person"></i></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_front('Last Name') }}</label>
                    <div class="icon-field">
                        <input type="text" name="l_name" class="form-control"
                            placeholder="{{ tt_front('Enter Last Name') }}" autocomplete="off">
                        <span class="icon"><i class="bi bi-person"></i></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_front('Email') }}</label>
                    <div class="icon-field">
                        <input type="email" name="email" class="form-control"
                            placeholder="{{ tt_front('Enter Email Address') }}" autocomplete="off">
                        <span class="icon"><i class="bi bi-envelope"></i></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_front('Mobile') }}</label>
                    <div class="form-control">
                        <input type="tel" name="mobile" id="phone" value="{{ old('mobile') }}" autocomplete="off">
                        <input type="hidden" name="country" id="country" >
                        <input type="hidden" name="country_code" id="country_code" >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="password-status-box-wrapper">
                        <label class="form-label">{{ tt_front('Password') }}</label>
                        <div class="password-field icon-field">
                            <input type="password" name="password" id="password" class="form-control"
                                placeholder="{{ tt_front('Enter Password') }}">
                            <span class="icon"><i class="bi bi-lock"></i></span>
                            <button type="button" class="password-field-btn">
                                <span class="eye-one"><i class="ri-eye-line"></i></span>
                                <span class="eye-off"><i class="ri-eye-off-line"></i></span>
                            </button>
                        </div>
                        @if (tc()->get('strong_password'))
                            <div class="password-status-box">
                                <p class="mb-2">{{ tt_front('Password must contain') }}:</p>
                                <ul id="password-criteria" class="text-sm">
                                    <li id="length" class="not-valid">
                                        {{ tt_front('At least 6 characters') }}
                                    </li>
                                    <li id="lowercase" class="not-valid">
                                        {{ tt_front('At least one lowercase letter') }}</li>
                                    <li id="uppercase" class="not-valid">
                                        {{ tt_front('At least one uppercase letter') }}</li>
                                    <li id="number" class="not-valid">
                                        {{ tt_front('At least one number') }}</li>
                                    <li id="special" class="not-valid">
                                        {{ tt_front('At least one special character (@$!%*?&)') }}
                                    </li>
                                </ul>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ tt_front('Confirm Password') }}</label>
                    <div class="password-field icon-field">
                        <input type="password" name="password_confirmation" class="form-control"
                            placeholder="{{ tt_front('Confirm Password') }}">
                        <span class="icon"><i class="bi bi-lock"></i></span>
                        <button type="button" class="password-field-btn">
                            <span class="eye-one"><i class="ri-eye-line"></i></span>
                            <span class="eye-off"><i class="ri-eye-off-line"></i></span>
                        </button>
                    </div>
                </div>
                <x-recaptcha></x-recaptcha>
            </div>
            <button type="submit" class="btn btn-primary-gradient w-100 mt-4">{{ tt_front('Sign Up') }}</button>
            @if (tc()->get('facebook_status') || tc()->get('google_status'))
                <div class="or-divider mt-4 mb-3">
                    <span>{{ tt_front('or') }}</span>
                </div>

                <div class="d-flex align-items-center gap-2">
                    @if (tc()->get('facebook_status'))
                        <a href="{{ route('facebook.redirect') }}" class="btn btn-outline-light shadow-none flex-grow-1">
                            <i class="fa-brands fa-facebook"></i>
                            <span>{{ tt_front('Facebook') }}</span>
                        </a>
                    @endif
                    @if (tc()->get('google_status'))
                        <a href="{{ route('google.redirect') }}" class="btn btn-outline-light shadow-none flex-grow-1">
                            <i class="fa-brands fa-google"></i>
                            <span>{{ tt_front('Google') }}</span>
                        </a>
                    @endif
                </div>
            @endif
        </form>
    </div>
@endsection


@push('style')
    <link rel="stylesheet" href="{{ css('intlTelInput.css', cons()::ASSETS_FROM_FRONTEND) }}">

    <style>
        .password-status-box-wrapper {
        position: relative;
        z-index: 1;
        }

        .password-status-box {
        position: absolute;
        top: 115%;
        left: 0;
        width: 100%;
        background-color: var(--surface-bg);
        padding: 20px;
        border-radius: 8px;
        border: 1px solid var(--border-color);
        z-index: 2;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.05);
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s;
        }

        .password-status-box.active {
        top: 106%;
        opacity: 1;
        visibility: visible;
        }

        #password-criteria {
        display: flex;
        flex-flow: column;
        gap: 8px 0;
        }

        #password-criteria li {
        position: relative;
        display: flex;
        align-items: center;
        gap: 4px;
        order: 1;
        }

        #password-criteria li::before {
        content: "\f622";
        font-family: bootstrap-icons !important;
        font-style: normal;
        font-weight: 400 !important;
        color: var(--danger);
        }

        #password-criteria li.valid-pass {
        order: -1;
        }

        #password-criteria li.valid-pass::before {
        content: "\f26a";
        color: var(--success);
        opacity: 1;
        }
    </style>
@endpush

@push('script')
    <script src="{{ js('intlTelInput.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    <script>
        'use strict'

        const input = document.querySelector("#phone");

        var iti = window.intlTelInput(input, {
            separateDialCode: true,
            initialCountry: "auto",
            geoIpLookup: function(callback) {
                fetch('https://ipinfo.io/json', {
                        headers: {
                            'Accept': 'application/json'
                        }
                    })
                    .then((resp) => resp.json())
                    .then((resp) => {
                        var countryCode = (resp && resp.country) ? resp.country : "us";
                        callback(countryCode);
                    });
            },

            utilsScript: "{{ js('utils.js', cons()::ASSETS_FROM_FRONTEND) }}",
        });


        input.addEventListener("countrychange", function() {
            var countryData = iti.getSelectedCountryData();
            var countryName = countryData.name;
            document.querySelector("#country").value = countryName;

            var countryCode = iti.getSelectedCountryData().dialCode;
            document.getElementById("country_code").value = countryCode;
        });


        @if (tc()->get('strong_password'))

            const passwordInput = document.getElementById('password');
            const criteria = {
                length: document.getElementById('length'),
                lowercase: document.getElementById('lowercase'),
                uppercase: document.getElementById('uppercase'),
                number: document.getElementById('number'),
                special: document.getElementById('special')
            };

            passwordInput.addEventListener('input', function() {
                const password = passwordInput.value;

                // Check length
                criteria.length.classList.toggle('valid-pass', password.length >= 6);
                criteria.length.classList.toggle('not-valid', password.length < 6);

                // Check for lowercase letters
                criteria.lowercase.classList.toggle('valid-pass', /[a-z]/.test(password));
                criteria.lowercase.classList.toggle('not-valid', !/[a-z]/.test(password));

                // Check for uppercase letters
                criteria.uppercase.classList.toggle('valid-pass', /[A-Z]/.test(password));
                criteria.uppercase.classList.toggle('not-valid', !/[A-Z]/.test(password));

                // Check for numbers
                criteria.number.classList.toggle('valid-pass', /[0-9]/.test(password));
                criteria.number.classList.toggle('not-valid', !/[0-9]/.test(password));

                // Check for special characters
                criteria.special.classList.toggle('valid-pass', /[@$!%*?&]/.test(password));
                criteria.special.classList.toggle('not-valid', !/[@$!%*?&]/.test(password));
            });
        @endif

        // Select the password field and the status box
        const passwordField = document.getElementById('password');
        const statusBox = document.querySelector('.password-status-box');

        // Check if both elements exist in the DOM
        if (passwordField && statusBox) {
            // Add a class when the password field is focused
            passwordField.addEventListener('focus', () => {
                statusBox.classList.add('active'); // 'active' is the class to add
            });

            // Remove the class when the password field loses focus
            passwordField.addEventListener('blur', () => {
                statusBox.classList.remove('active');
            });
        }
    </script>
@endpush
