@extends('frontend::auth.auth_master')
@section('content')
    <div class="it-auth-content">
        <div class="text-center mb-4">
            <h3>{{ cms('auth', 'password_reset_title') }}</h3>
            <p class="mb-0">{{ tt_front('Create a new password to replace the old one and secure your account.') }}</p>
        </div>

        <form method="POST">
            @csrf

            <div class="mb-4">
                <div class="password-status-box-wrapper">
                    <label class="form-label">{{ tt_front('Password') }}</label>
                    <div class="password-field icon-field">
                        <input type="password" name="password" class="form-control" id="password"
                            placeholder="Enter Password">
                        <span class="icon"><i class="ri-lock-line"></i></span>
                        <button type="button" class="password-field-btn">
                            <span class="eye-one"><i class="ri-eye-line"></i></span>
                            <span class="eye-off"><i class="ri-eye-off-line"></i></span>
                        </button>
                    </div>


                    @if (tc()->get('strong_password'))
                        <div class="password-status-box">
                            <p class="mb-2">{{ tt_front('Password must contain') }}:</p>
                            <ul id="password-criteria" class="text-sm">
                                <li id="length" class="not-valid">{{ tt_front('At least 6 characters') }}
                                </li>
                                <li id="lowercase" class="not-valid">
                                    {{ tt_front('At least one lowercase letter') }}</li>
                                <li id="uppercase" class="not-valid">
                                    {{ tt_front('At least one uppercase letter') }}</li>
                                <li id="number" class="not-valid">{{ tt_front('At least one number') }}</li>
                                <li id="special" class="not-valid">
                                    {{ tt_front('At least one special character (@$!%*?&)') }}
                                </li>
                            </ul>
                        </div>
                    @endif
                </div>
            </div>
            <div class="mb-4">
                <label class="form-label">{{ tt_trans('Confirm Password') }}</label>
                <div class="password-field icon-field">
                    <input type="password" name="password_confirmation" class="form-control" placeholder="Enter Password">
                    <span class="icon"><i class="ri-lock-line"></i></span>
                    <button type="button" class="password-field-btn">
                        <span class="eye-one"><i class="ri-eye-line"></i></span>
                        <span class="eye-off"><i class="ri-eye-off-line"></i></span>
                    </button>
                </div>
            </div>


            @if (tc()->get('strong_password'))
                <div class="password-status-box">
                    <p class="mb-2">{{ tt_front('Password must contain') }}:</p>
                    <ul id="password-criteria" class="text-sm">
                        <li id="length" class="not-valid">{{ tt_front('At least 6 characters') }}
                        </li>
                        <li id="lowercase" class="not-valid">
                            {{ tt_front('At least one lowercase letter') }}</li>
                        <li id="uppercase" class="not-valid">
                            {{ tt_front('At least one uppercase letter') }}</li>
                        <li id="number" class="not-valid">{{ tt_front('At least one number') }}</li>
                        <li id="special" class="not-valid">
                            {{ tt_front('At least one special character (@$!%*?&)') }}
                        </li>
                    </ul>
                </div>
            @endif


            <x-recaptcha></x-recaptcha>

            <button type="submit" class="btn btn-primary-gradient w-100 mt-4">{{ tt_front('Login') }}</button>
        </form>
    </div>
@endsection


@push('script')
    <script>
        'use strict'

        @if (tc()->get('strong_password'))

            const passwordInput = document.getElementById('password');
            const criteria = {
                length: document.getElementById('length'),
                lowercase: document.getElementById('lowercase'),
                uppercase: document.getElementById('uppercase'),
                number: document.getElementById('number'),
                special: document.getElementById('special')
            };

            passwordInput.addEventListener('input', function() {
                const password = passwordInput.value;

                // Check length
                criteria.length.classList.toggle('valid-pass', password.length >= 6);
                criteria.length.classList.toggle('not-valid', password.length < 6);

                // Check for lowercase letters
                criteria.lowercase.classList.toggle('valid-pass', /[a-z]/.test(password));
                criteria.lowercase.classList.toggle('not-valid', !/[a-z]/.test(password));

                // Check for uppercase letters
                criteria.uppercase.classList.toggle('valid-pass', /[A-Z]/.test(password));
                criteria.uppercase.classList.toggle('not-valid', !/[A-Z]/.test(password));

                // Check for numbers
                criteria.number.classList.toggle('valid-pass', /[0-9]/.test(password));
                criteria.number.classList.toggle('not-valid', !/[0-9]/.test(password));

                // Check for special characters
                criteria.special.classList.toggle('valid-pass', /[@$!%*?&]/.test(password));
                criteria.special.classList.toggle('not-valid', !/[@$!%*?&]/.test(password));
            });
        @endif

        // Select the password field and the status box
        const passwordField = document.getElementById('password');
        const statusBox = document.querySelector('.password-status-box');

        // Add a class when the password field is focused
        passwordField.addEventListener('focus', () => {
            statusBox.classList.add('active'); // 'active' is the class to add
        });

        // Remove the class when the password field loses focus
        passwordField.addEventListener('blur', () => {
            statusBox.classList.remove('active');
        });
    </script>
@endpush
