@extends('frontend::auth.auth_master')
@section('content')
    <div class="it-auth-content">
        <div class="text-center mb-4">
            @if (user()->ability->kyc_verified == cons()::PENDING)
                <div class="like-container">
                    <div class="like-thumb">
                        <div class="like-thumb-inner">
                            <iconify-icon icon="hugeicons:user-id-verification"></iconify-icon>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-4">
                    <h4 class="">{{ tt_front('Your KYC request is pending') }}</h4>
                    <p>{{ tt_front('Please wait until Admin approve your kyc verification request.') }}</p>
                    <div class="d-flex align-items-center justify-content-center gap-3">
                        <a href="{{ route('home') }}" class="text-primary fw-medium"><i
                                class="ri-arrow-left-line"></i>{{ tt_front('Back to Home') }}</a>
                        <span>{{ tt_front('or') }}</span>
                        <a href="{{ route('logout') }}" class="text-primary fw-medium"><i class="ri-logout-circle-line"></i>
                            {{ tt_front('Logout') }}</a>
                    </div>
                </div>
            @else
                <div class="text-center mb-sm-5 mb-4">
                    <h3>{{ tt_front('Kyc Verification') }}</h3>
                </div>
            @endif
        </div>

        <form method="POST" enctype="multipart/form-data">
            @csrf
            @foreach ($kyc as $verify)
                <div class="mb-3">
                    <label class="form-label">{{ tt_front($verify->label_name) }}</label>

                    @if ($verify->field_type == 'file')
                        <input type="file" name="{{ $verify->field_name }}" class="form-control">
                    @elseif($verify->field_type == 'text')
                        <input type="text" name="{{ $verify->field_name }}" class="form-control">
                    @else
                        <textarea name="{{ $verify->field_name }}"cols="30" rows="10" class="form-control"></textarea>
                    @endif
                </div>
            @endforeach

            <x-recaptcha></x-recaptcha>

            <button type="submit" class="btn btn-primary-gradient w-100 mt-4">{{ tt_front('Verify') }}</button>
        </form>
    </div>
@endsection
