@extends('frontend::layouts.master')
@section('content')
<div class="rt-section-pt rt-section-pb">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-8 col-lg-10 col-md-8">
                <a href="{{ route('home') }}" class="mb-4 d-lg-none"><img src="{{ getFile('logo', $themeSettings->dark_logo, '200x50') }}" alt="image" class="rt-auth-logo"></a>
                <div class="rt-auth-box">
                    <div class="mb-4">
                        <h3>{{tt_front('Verify Code from Sms')}}</h3>
                    </div>
                    <form method="POST" >
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">{{tt_front('Verify Code')}}</label>
                            <input type="text" name="code" class="form-control">
                        </div>

                        <x-recaptcha></x-recaptcha>

                        <button type="submit" class="btn rt-solid-btn-primary w-100">{{tt_front('Verify')}}</button>
                    </form>

                    <div class="d-flex align-items-center justify-content-center gap-3 mt-4">
                        <a href="{{route('home')}}" class="text-primary fw-medium"><i class="ri-arrow-left-line"></i> {{tt_front('Back to Home')}}</a>
                        <span>{{tt_front('or')}}</span>
                        <a href="{{route('logout')}}" class="text-primary fw-medium"><i class="ri-logout-circle-line"></i> {{tt_front('Logout')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
