@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="row gy-xl-4 gy-3">
            <div class="col-xxl-8">
                <div class="row g-sm-4 g-3">
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Token Balance') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="ic:twotone-token"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ $totalToken }} {{ $setting->token_symbol ?? "" }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Last purchase') }} <span class="text-success">{{ $lastPurchaseToken->token ?? 0 }} {{ $setting->token_symbol ?? "" }}</span></p>
                        </div>
                    </div>
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Current Balance') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="solar:wallet-bold-duotone"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ symbol($totalbalance) }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Last transaction ') }}
                                @if ($transactions->first())
                                    @if ($transactions->first()->type == '+')
                                        <span class="text-success">
                                            {{ number_format($transactions->first()->amount, $transactions->first()->formatter) }}
                                            {{ $transactions->first()->currency }}
                                        </span>
                                    @else
                                        <span class="text-danger">
                                            {{ number_format($transactions->first()->amount, $transactions->first()->formatter) }}
                                            {{ $transactions->first()->currency }}
                                        </span>
                                    @endif
                                @else
                                    0 {{ tc()->get('currency') }}
                                @endif
                            </p>
                        </div>
                    </div>
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Total Auction') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="mingcute:auction-line"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ $totalAuction }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Running auctions') }} <span
                                    class="text-success">{{ $totalRunningAuction }}</span></p>
                        </div>
                    </div>
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Total Deposit') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="ph:hand-deposit-duotone"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ symbol($totalDeposit) }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Last deposit') }} <span class="text-success">
                                    {{ $user->deposits()->latest()->first() ? symbol($user->deposits()->latest()->first()->amount) : 0 }}</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Total Withdraw') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="ph:hand-withdraw-duotone"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ symbol($totalWithdraw) }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Last withdraw') }} <span
                                    class="text-warning">{{ $user->withdraws()->latest()->first() ? symbol($user->withdraws()->latest()->first()->amount) : 0 }}</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-sm-4 col-6">
                        <div class="info-card">
                            <div class="info-card-top">
                                <p class="mb-0 flex-grow-1">{{ tt_front('Total Ticket') }}</p>
                                <span class="icon">
                                    <iconify-icon icon="ph:ticket-duotone"></iconify-icon>
                                </span>
                            </div>

                            <h4 class="info-card-amount h5">{{ $totalSupportTickets }}</h4>
                            <p class="text-sm mb-0 mt-2">{{ tt_front('Open Ticket') }} <span
                                    class="text-success">{{ $totalOpenTicket }}</span></p>
                        </div>
                    </div>
                </div>
            </div>
            @if (getActiveStage()['stage'])
                <div class="col-xxl-4 col-md-6">
                    <div class="card">
                        <div class="card-body p-lg-4 p-3">
                            <div class="d-flex align-items-center gap-3">
                                <img src="{{ getFile('ico_icon', $setting->icon) }}" alt="image"
                                    class="avatar-md flex-shrink-0">
                                <h6 class="mb-0 flex-grow-1 text-md">{{ $setting->token_symbol ?? "" }} {{ tt_front('Token') }}
                                </h6>
                            </div>
                            <div class="d-flex align-items-center gap-2 justify-content-between mt-4">
                                <div>
                                    <h6 class="mb-1">{{ getActiveStage()['stage']->remainToken() }}
                                        {{ $setting->token_symbol }} {{ tt_front('remain') }}</h6>
                                    <p class="mb-0 text-sm">
                                        {{ symbol(getActiveStage()['stage']->remainToken() * getActiveStage()['stage']->base_price) }}
                                    </p>
                                </div>
                                <p class="mb-0">1 {{ $setting->token_symbol }} =
                                    {{ symbol(getActiveStage()['stage']->base_price) }}</p>
                            </div>
                            <hr>

                            <div class="d-flex flex-wrap gap-2 align-items-center justify-content-between mb-xl-0 mb-2">
                                <h6 class="text-sm">{{ getActiveStage()['stage']->title }}</h6>
                                <span class="badge badge-primary">{{ tt_front('Running') }}</span>
                            </div>

                            <div id="ico-timer"></div>

                            <div class="d-flex flex-wrap align-items-center gap-3 mt-xxl-3 mt-4">
                                <a href="{{ route('stage.buy', getActiveStage()['stage']->id) }}"
                                    class="btn btn-md btn-primary-gradient flex-grow-1">
                                    {{ tt_front('Buy') }}
                                    <i class="bi bi-arrow-down-left"></i>
                                </a>
                                <a href="{{ route('auction.create') }}"
                                    class="btn btn-md btn btn-outline-light flex-grow-1">
                                    {{ tt_front('Create Auction') }}
                                    <i class="bi bi-arrow-up-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="col-xxl-4 col-md-6">
                    <div class="card no-stage-card h-100 py-4">
                        <div>
                            <div class="icon">
                                <iconify-icon icon="bx:layer"></iconify-icon>
                            </div>
                            <h6 class="text-sm mt-2 text-center">{{ tt_front('No Stage Available') }}</h6>
                        </div>
                    </div>
                </div>
            @endif

            <div class="col-xxl-5 col-md-6">
                <div class="card h-100">
                    <div class="card-body p-lg-4 p-3">
                        <h6 class="text-lg">{{ tt_front('Overview') }}</h6>
                        <div id="chart-two"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-md-6">
                <div class="card h-100">
                    <div class="card-body p-lg-4 p-3">
                        <h6 class="text-lg">{{ tt_front('Auction Overview') }}</h6>
                        <div id="buysell"></div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-4 col-md-6">
                <div class="card h-100">
                    <div class="card-body p-lg-4 p-3">
                        <h6 class="text-lg mb-4">{{ tt_front('Recent Transaction') }}</h6>

                        <ul class="it-recent-transaction-list scroll-y">
                            @forelse ($transactions as $transaction)
                                <li>
                                    <div class="d-flex align-items-center gap-2 position-relative">
                                        <a href="javascript:void(0)" class="position-absolute w-100 h-100"></a>
                                        <div class="d-flex align-items-center flex-grow-1">
                                            <div class="date-border-line">
                                                <span
                                                    class="date">{{ dateFormatter($transaction->created_at, 'd') }}</span>
                                                <span
                                                    class="month">{{ dateFormatter($transaction->created_at, 'M') }}</span>
                                            </div>
                                            <div class="ps-2">
                                                <h6 class="text-sm mb-0">{{ $transaction->reason }}</h6>
                                                <span class="text-xs">{{ tt_front('TRX') }}:
                                                    {{ $transaction->trx }}</span>
                                            </div>
                                        </div>
                                        <div class=" text-end">
                                            @if ($transaction->type == '+')
                                                <h6 class="text-sm mb-0 text-success">
                                                    +{{ number_format($transaction->amount, $transaction->formatter) }}
                                                    {{ $transaction->currency }}</h6>
                                            @else
                                                <h6 class="text-sm mb-0 text-danger">
                                                    -{{ number_format($transaction->amount, $transaction->formatter) }}
                                                    {{ $transaction->currency }}</h6>
                                            @endif

                                            <span
                                                class="text-xs">{{ dateFormatter($transaction->created_at, 'h:i A') }}</span>
                                        </div>
                                    </div>
                                </li>
                            @empty
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4">
            <h6 class="text-lg">{{ tt_front('Your referral link') }}</h6>
            <form>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" placeholder="{{ tt_front('Copy link') }}"
                        value="{{ route('registration', user()->username) }}" readonly>
                    <span class="input-group-text btn-primary-gradient text-white copy-btn">{{ tt_front('Copy') }} <i
                            class="bi bi-copy ms-2"></i></span>
                </div>
            </form>
        </div>

        <div class="card mt-xl-4 mt-3">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2">
                <h4 class="card-title mb-0">{{ tt_front('Recent Auctions') }}</h4>
                <a href="{{ route('auction.list') }}" class="text-sm text-primary">{{ tt_front('View All ') }}<i
                        class="bi bi-arrow-up-right"></i></a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table default-table head-light-bg responsive-table mb-0 radius-lg">
                        <thead>
                            <tr>
                                <th>{{ tt_front('SL') }}</th>
                                <th>{{ tt_front('Seller') }}</th>
                                <th>{{ tt_front('End Date') }}</th>
                                <th>{{ tt_front('Quantity') }}</th>
                                <th>{{ tt_front('Total Price') }}</th>
                                <th>{{ tt_front('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($auctions as $auction)
                                <tr>
                                    <td>
                                        <span class="fw-semibold">{{ $loop->iteration }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="{{ getFile('user', $auction->user->image) }}"
                                                class="avatar-lg object-fit-cover rounded-circle flex-shrink-0"
                                                alt="image">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0 text-sm">{{ $auction->user->fullname }}</h6>
                                                <p class="mb-0">{{ $auction->user->email }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <h6 class="mb-0 text-sm">{{ dateFormatter($auction->end_date, 'd M Y') }}</h6>
                                        <p class="mb-0">{{ dateFormatter($auction->end_date, 'H:I') }}</p>
                                    </td>
                                    <td>
                                        <p class="mb-0">{{ $auction->availableToken() }} {{ $setting->token_symbol }}
                                        </p>
                                    </td>
                                    <td>
                                        <p class="mb-0">
                                            {{ symbol($auction->token_base_price * $auction->availableToken()) }}</p>
                                    </td>
                                    <td>
                                        <a href="{{ route('auction.buy', $auction->trx) }}"
                                            class="btn btn-sm btn-primary-gradient flex-grow-1">
                                            {{ tt_front('Buy Now') }}
                                            <i class="bi bi-arrow-up-right"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">
                                        <div class="no-data-wrapper">
                                            <div class="w-100">
                                                <div class="row justify-content-center">
                                                    <div class="col-lg-6 text-center">
                                                        <img src="{{ getFile('constant_image', 'no-data-found.png') }}"
                                                            alt="image" class="no-data-wrapper-img">
                                                        <p class="mt-4 mb-0 text-md">{{ tt_front('No auction found.') }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script src="{{ js('apexcharts.min.js') }}"></script>
    <script src="{{ js('jquery.countdown.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    <script>
        $(function() {
            'use strict';

            @if (getActiveStage()['stage'])
                let end = "{{ dateFormatter(getActiveStage()['stage']->end_date, 'Y/m/d') }}";

                $('#ico-timer').countdown(end, function(event) {
                    $(this).html(event.strftime('' +
                        '<div class="single-time"><div class="single-time-inner"><span>%D</span> <p>D</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%H</span> <p>H</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%M</span> <p>M</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%S</span> <p>S</p></div></div>'
                    ));
                });
            @endif

            const depositData = @json($finalDepositData);
            const withdrawData = @json($finalWithdrawData);


            var options = {
                series: [{
                    name: "{{ tt_front('Deposit') }}",
                    data: depositData
                }, {
                    name: "{{ tt_front('Withdraw') }}",
                    data: withdrawData
                }],
                chart: {
                    type: 'area',
                    height: 240,
                    foreColor: '#ffffff80'
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '40%',
                        borderRadius: 5,
                        borderRadiusApplication: 'end'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: @json($dates),
                },
                yaxis: {
                    title: {
                        text: "{{ tt_front('Amount') }}"
                    }
                },
                grid: {
                    show: false,
                },
                fill: {
                    opacity: 1,
                    colors: ['#805af5', '#ce99ff']
                },
                colors: ['#805af5', '#ce99ff'],
                legend: {
                    labels: {
                        colors: ['#ffffff']
                    }
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return val + " " + "{{ tc()->get('currency') }}"
                        }
                    }
                }
            };

            var chart = new ApexCharts(document.querySelector("#chart-two"), options);
            chart.render();

            const buyToken = @json($finalPurchaseData);
            const saleToken = @json($finalSaleData);
            const auctionDates = @json($auctionDates);

            var optionsTwo = {
                series: [{
                    name: 'Buy',
                    data: buyToken
                }, {
                    name: 'Sell',
                    data: saleToken
                }],
                chart: {
                    type: 'bar',
                    height: 240
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '35%',
                        borderRadius: 5,
                        borderRadiusApplication: 'end'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                colors: ["var(--primary)", "var(--success)"],
                xaxis: {
                    categories: auctionDates
                },
                yaxis: {
                    title: {
                        text: 'Tokens'
                    }
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function(val) {
                            return val;
                        }
                    }
                }
            };

            var chart = new ApexCharts(document.querySelector("#buysell"), optionsTwo);
            chart.render();
        });
    </script>
@endpush
