<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>{{ tc()->get('sitename') }}</title>

    <link rel="icon" type="image/png" href="{{ getFile('icon', $themeSettings->icon) }}" sizes="16x16">

    @include('frontend::partials.header-style')
</head>

<body>

    <x-preloader></x-preloader>

    <div class="cursor"></div>
    <div class="cursor-follower"></div>

    <button type="button" class="top-action-btn">
        <span class="icon">
            <iconify-icon icon="ci:arrow-up-lg"></iconify-icon>
        </span>
        <span class="caption">{{ tt_front('Top') }}</span>
    </button>

    <main id="main-container">
        <div class="user-dashboard">
            @include('frontend::partials.sidebar')
            @include('frontend::partials.top_bar')

            <div class="user-dashbaord-body">
                @yield('content')
            </div>

            <footer class="user-footer">
                <div class="container">
                    <p class="mb-0 text-sm text-center">{{ tt_front(tc()->get('copyright')) }}</p>
                </div>
            </footer>
        </div>
    </main>

    @if (tc()->get('cookie_status'))
        @include('frontend::partials.cookie')
    @endif

    @include('frontend::partials.footer-script')
</body>

</html>
