<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ tt_front('Maintanance') }}</title>

    <link href="{{ $themeSettings->heading_font }}" rel="stylesheet">

    <link href="{{ $themeSettings->paragraph_font }}" rel="stylesheet">

    <link rel="stylesheet" href="{{ css('remixicon.css') }}">

    <link rel="stylesheet" href="{{ css('all.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap-icons.min.css') }}">

    <link rel="stylesheet" href="{{ css('bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ css('style.css', cons()::ASSETS_FROM_FRONTEND) }}">
    <style>
        :root {
            --display-font: <?=$themeSettings?->heading_font_family ?>;
            --body-font: <?=$themeSettings?->paragraph_font_family ?>;
            --primary: <?=$themeSettings?->primary_color ?? '#FF6D13' ?>;
            --primary-two: <?=$themeSettings?->secondary_color ?? '#c3b72a' ?>;

        }
    </style>
</head>

<body>
    
    <main id="main-container">
        <div class="maintenance-page">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-4 col-xl-6 col-lg-7 col-md-8">
                        <div>
                            <img src="{{ getFile('logo', $themeSettings->dark_logo) }}" alt="image" class="maintenance-page-logo">
                        </div>
    
                        <span class="maintenance-page-caption">{{ tt_front('Under Maintenance')}}</span>
                        <h2 class="maintenance-page-title">{{ tc()->get('maintanance_title') }}</h2>
                        <?= tc()->get('maintanance_description') ?>
    
                        <div class="social-media-links mt-4">
                            <ul>
                                <li>
                                    <a href="{{ tc()->get('maintanance_social')['facebook_link'] ?? '' }}" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
                                </li>
                                <li>
                                    <a href="{{ tc()->get('maintanance_social')['twitter_link'] ?? '' }}" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
                                </li>
                                <li>
                                    <a href="{{ tc()->get('maintanance_social')['linkdin_link'] ?? '' }}" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>
                                </li>
                                <li>
                                    <a href="{{ tc()->get('maintanance_social')['pinterest_link'] ?? '' }}" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="maintenance-page-icons">
                <span class="first-icon">
                    <iconify-icon icon="system-uicons:settings"></iconify-icon>
                </span>
                <span class="second-icon">
                    <iconify-icon icon="system-uicons:settings"></iconify-icon>
                </span>
                <span class="third-icon">
                    <iconify-icon icon="system-uicons:settings"></iconify-icon>
                </span>
            </div>
        </div>
    </main>
    
    
    
    
    <script src="{{ js('jquery-3.7.1.min.js') }}"></script>
    <script src="{{ js('jquery-ui.min.js') }}"></script>
    <script src="{{ js('iconify-icon.min.js') }}"></script>
</body>

</html>
