@forelse($messages as $message)
    <div class="single-chat-message {{ $message->sender_id != $receiver->id ? 'own-message' : '' }} ">
        <p
            class="{{ $message->sender_id != $receiver->id ? 'bg-primary' : 'bg-dark' }} text-sm text-white py-2 px-3 rounded-2 mb-0">
            {{ $message->message ?? 'Deleted' }}
        </p>
        <p class="mb-0 text-xs mt-1 {{ $message->sender_id != $receiver->id ? 'text-end' : '' }} ">
            {{ $message->created_at->diffForHumans() }}</p>
    </div>
@empty
    <div class="no-message">
        <span class="icon">
            <iconify-icon icon="hugeicons:message-cancel-02"></iconify-icon>
        </span>
        <p class="mb-0">No Message Yet</p>
    </div>
@endforelse
