@extends('frontend::layouts.user_master')
@section('content')
    <div class="container-fluid">
        <div class="message-chat-area">
            <div class="message-chat-list-area scroll-y">
                <div class="icon-field mb-4">
                    <input type="text" name="searching" class="form-control form-control-md">
                    <span class="icon">
                        <i class="ri-search-line"></i>
                    </span>
                </div>
                <div class="message-sender-wrapper">
                    @include('frontend::messages.sidebar', ['senders' => $senders])
                </div>
            </div>
            <div class="message-chat-wrapper">
                <div class="message-chat-wrapper-header">

                </div>
                <div class="message-chat-wrapper-body scroll-y">

                </div>
                <div class="message-chat-wrapper-footer">
                    <div class="chatting-form">
                        <textarea name="message" cols="6" rows="3" class="form-control" placeholder="Write Reply..."></textarea>
                        <button type="submit" class="btn btn-sm btn-primary reply-btn"><i class="ri-reply-line"></i>
                            {{ tt_front('Send') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use script'



        function loadOldMessages(userOne, userTwo, isRead = 0) {
            $.ajax({
                url: "{{ route('message.old') }}",
                type: "GET",
                data: {
                    user_one: userOne,
                    user_two: userTwo,
                    is_read: isRead
                },
                success: function(response) {
                    if (response.status === 'success') {
                        $(".message-chat-wrapper-header").html(`${response.data.header}`);
                        $(".message-chat-wrapper-body").html(`${response.data.body}`);
                        $(".message-sender-wrapper").html(`${response.data.sidebar}`);
                    }

                    scroller();
                },
                error: function(xhr) {
                    console.error('Error:', xhr.responseJSON.message || 'An error occurred.');
                }
            })
        }

        function sendMessage(sender, receiver, message) {

            $.ajax({
                url: "{{ route('message.send') }}",
                type: "POST",
                data: {
                    message: message,
                    _token: "{{ csrf_token() }}",
                    receiver_id: receiver
                },
                success: function(response) {
                    if (response.status === 'success') {
                        $("textarea[name=message]").val('');
                        loadOldMessages(sender, receiver, 1);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let errorMessages = Object.values(errors).map(error => error[0]);


                        $.toast({
                            text: `<i class='fa-solid fa-circle-exclamation'></i> ${errorMessages}`,
                            showHideTransition: 'slide',
                            bgColor: 'var(--warning)',
                            textColor: '#fff',
                            allowToastClose: true,
                            hideAfter: 3000,
                            stack: 5,
                            textAlign: 'left',
                            position: 'top-right'
                        });


                    } else {
                        console.error('Error:', xhr.responseJSON.message || 'An error occurred.');
                    }
                }
            })
        }

        let user = "{{ user()->id }}";
        let sender = $('.message-chat-list-single.active').data('sender');

        loadOldMessages(user, sender,1);


        $(document).on('click', '.message-chat-list-single', function() {
            let sender = $(this).data('sender');
            loadOldMessages(user, sender, 1);

            $('.message-chat-list-single').removeClass('active');
            $(this).addClass('active');
        })

        $(".reply-btn").on('click', function() {
            var message = $("textarea[name=message]").val();
            var receiver = $('.message-chat-list-single.active').data('sender');

            sendMessage("{{ user()->id }}", receiver, message)
        })


        function scroller() {
            const chatWrapper = document.querySelector('.message-chat-wrapper-body');

            if (chatWrapper) {
                setTimeout(() => {
                    const lastMessage = chatWrapper.querySelector('.single-chat-message:last-child');
                    if (lastMessage) {
                        const lastMessageHeight = lastMessage.offsetTop + lastMessage.offsetHeight;
                        chatWrapper.scrollTop = chatWrapper.scrollHeight;
                    }
                }, 300);
            }
        }


        $("input[name=searching]").on('input', function() {
            let key = $(this).val();
            let chatList = $('.message-chat-list-single');

            chatList.each(function() {
                let text = $(this).text().toLowerCase();
                if (text.includes(key)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    </script>
@endpush
