@forelse($senders as $sender)
    @php
        $isActive = '';

        if (isset($userTwo)) {
            if ($sender->id == $userTwo) {
                $isActive = 'active';
            }
        } else {
            if ($loop->first) {
                $isActive = 'active';
            }
        }
        $conversation = \App\Models\Conversation::findOrCreateConversation(user()->id, $sender->id);
    @endphp

    <div class="message-chat-list-single {{ $isActive }}" data-sender="{{ $sender->id }}">
        <div class="thumb">
            <img src="{{ getFile('user', $sender->image) }}" alt="image">
        </div>
        <div class="content">
            <h6 class="mb-0 text-md text-line-1">{{ $sender->fullname }}</h6>
            <p class="text-sm mb-0">{{ $sender->email }}</p>
        </div>
        <div class="time-noti text-end ms-auto">
            <p class="text-sm mb-0 line-height-1 text-nowrap">
                {{ $conversation->messages()->latest()->first()->created_at->diffForHumans() }}</p>
            @if ($sender->unreadMessage() > 0)
                <span
                    class="avatar-xxs bg-primary text-white rounded-circle d-inline-flex justify-content-center align-items-center text-xs">{{ $sender->unreadMessage() }}</span>
            @endif
        </div>
    </div>
@empty
@endforelse
