@extends('frontend::layouts.master')
@section('content')
    <section class="it-blog it-section-pt it-section-pb">
        <div class="container">
            <div class="row gy-5">
                <div class="col-lg-8">
                    <div class="all-blogs">
                        @foreach ($blogs as $blog)
                            <div class="it-blog-grid">
                                <div class="it-blog-grid-thumb">
                                    <img src="{{ getFile('blogs', $blog->image) }}" alt="image">
                                    <span class="it-blog-grid-tag">{{ tt_front($blog->category->name) }}</span>
                                </div>
                                <div class="it-blog-grid-content">
                                    <h4 class="title"><a href="{{ route('blog.details', $blog->slug) }}"
                                            class="text-line-2">{{ tt_front($blog->title) }}</a></h4>
                                    <ul class="it-blog-meta mt-3">
                                        <li><i
                                                class="fa-regular fa-calendar-days"></i>{{ dateFormatter($blog->created_at) }}
                                        </li>
                                        <li><i class="fa-regular fa-user"></i> {{ $blog->admin->username }}</li>
                                    </ul>
                                    <p class="mt-3">{{ tt_front($blog->short_description) }}</p>
                                    <a href="{{ route('blog.details', $blog->slug) }}"
                                        class="it-blog-grid-btn">{{ tt_front('Read More') }}<i
                                            class="fa-solid fa-arrow-right"></i></a>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    @if ($blogs->hasPages())
                        <div class="pagination-style-two d-flex justify-content-center mt-xl-5 mt-4">
                            <nav aria-label="Page navigation example">
                                {{ $blogs->links() }}
                            </nav>
                        </div>
                    @endif
                </div>

                <div class="col-lg-4 ps-xl-4">
                    <div class="it-blog-sidebar">
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{ tt_front('Related Categories') }}</h5>
                            <ul class="it-blog-categires">
                                @foreach ($categories as $category)
                                    <li>
                                        <a href="{{ route('blog.category', $category->slug) }}"
                                            class="d-flex flex-wrap align-items-center justify-content-between">
                                            <span>{{ $category->name }}</span>
                                            <span class="fw-medium">({{ $category->blogs->count() }})</span>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{tt_front('Related Posts')}}</h5>
                            <ul class="it-short-post-list">
                                @foreach ($latestBlogs as $item)
                                    <li class="it-short-post">
                                        <div class="it-short-post-thumb">
                                            <a href="{{ route('blog.details', $item->slug) }}" class="d-block w-100 h-100">
                                                <img src="{{ getFile('blogs', $item->image) }}" alt="image">
                                            </a>
                                        </div>
                                        <div class="it-short-post-content">
                                            <h6 class="mb-2">
                                                <a href="{{ route('blog.details', $item->slug) }}"
                                                    class="text-sm text-line-2">{{ tt_front($item->title) }}</a>
                                            </h6>
                                            <ul class="it-blog-meta">
                                                <li><i class="fa-regular fa-calendar-days"></i></li>
                                                <li><i class="fa-regular fa-user"></i> {{ $item->admin->username }}</li>
                                            </ul>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{ tt_front('Tags') }}</h5>

                            <ul class="it-blog-tags">
                                @foreach ($tags as $tag)
                                    <li>
                                        <a href="{{ route('blog', ['tag' => $tag]) }}">{{ $tag }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
