@extends('frontend::layouts.master')

@push('seo')
    <meta name="keywords" content="{{ implode(',', $blog->seo_tags ?? []) }}">
    <meta name="description" content="{{ $blog->seo_description }}">

    <meta name="twitter:title" content="{{ $blog->title }}">
    <meta name="twitter:description" content="{{ $blog->seo_description }}">
    <meta name="twitter:image" content="{{ getFile('blogs', $blog->image, '850x570') }}">
    <meta name="twitter:card" content="{{ getFile('blogs', $blog->image, '850x570') }}">

    <meta property="og:type" content="{{ $blog->category->name }}" />
    <meta property="og:url" content="{{ url()->current() }}" />
    <meta property="og:title" content="{{ $blog->title }}" />
    <meta property="og:description" content="{{ $blog->seo_description }}" />
    <meta property="og:image" content="{{ getFile('blogs', $blog->image, '850x570') }}" />
@endpush


@section('content')
    <section class="it-section-pt it-section-pb">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="it-blog-details">
                        <div class="it-blog-details-thumb">
                            <img src="{{ getFile('blogs', $blog->image) }}" alt="image" class="rounded-4">
                        </div>
                        <ul class="it-blog-meta mt-4">
                            <li><i class="fa-regular fa-calendar-days"></i>{{ dateFormatter($blog->created_at) }}</li>
                            <li><i class="fa-regular fa-user"></i>{{ $blog->admin->username }}</li>
                        </ul>
                        <h3 class="it-blog-details-title mt-3">{{ $blog->title }}</h3>
                        <?= editor_data(section: $blog->description) ?>

                        <hr class="my-3">
                        <div class="d-flex flex-wrap align-items-center justify-content-between">
                            <h5>{{ tt_front('Share') }}:</h5>
                            <div class="social-media-links">
                                <?= $shareComponent ?>
                            </div>
                        </div>
                        <hr class="my-3">
                    </div>
                </div>
                <div class="col-lg-4 ps-xl-4">
                    <div class="it-blog-sidebar">
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{ tt_front('Related Categories') }}</h5>
                            <ul class="it-blog-categires">
                                @foreach ($categories as $category)
                                    <li>
                                        <a href="{{ route('blog.category', $category->slug) }}"
                                            class="d-flex flex-wrap align-items-center justify-content-between">
                                            <span>{{ tt_front($category->name) }}</span>
                                            <span class="fw-medium">({{ $category->blogs->count() }})</span>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{ tt_front('Related Posts') }}</h5>
                            <ul class="it-short-post-list">
                                @foreach ($latestBlogs as $latest)
                                    <li class="it-short-post">
                                        <div class="it-short-post-thumb">
                                            <a href="{{ route('blog.details', $latest->slug) }}"
                                                class="d-block w-100 h-100">
                                                <img src="{{ getFile('blogs', $latest->image) }}" alt="image">
                                            </a>
                                        </div>
                                        <div class="it-short-post-content">
                                            <h6 class="mb-2">
                                                <a href="{{ route('blog.details', $latest->slug) }}"
                                                    class="text-sm text-line-2">{{ tt_front($latest->title) }}</a>
                                            </h6>
                                            <ul class="it-blog-meta">
                                                <li><i
                                                        class="fa-regular fa-calendar-days"></i>{{ dateFormatter($latest->created_at) }}
                                                </li>
                                                <li><i class="fa-regular fa-user"></i>{{ $latest->admin->username }}</li>
                                            </ul>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="it-blog-sidebar-widget">
                            <h5 class="it-blog-sidebar-title">{{ tt_front('Tags') }}</h5>

                            <ul class="it-blog-tags">
                                @foreach ($tags as $tag)
                                    <li>
                                        <a href="{{ route('blog', $tag) }}">{{ tt_front($tag) }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
