@extends('frontend::layouts.master')

@push('seo')
    <meta name="keywords" content="{{ implode(',', $page->seo_keywords ?? []) }}">
    <meta name="description" content="{{ $page->seo_description }}">
@endpush


@section('content')
    @if ($page->sections->isNotEmpty())
        @foreach ($page->sections as $section)
            <?= renderSections($section) ?>
        @endforeach
    @endif


    @if ($page->description)
        <div class="it-section-pt it-section-pb editor-section">
            <div class="container">
                <?= editor_data(section: $page->description) ?>
            </div>
        </div>
    @endif
@endsection
