<script src="{{ js('jquery-3.7.1.min.js') }}"></script>
<script src="{{ js('jquery-ui.min.js') }}"></script>
<script src="{{ js('jquery.toast.min.js') }}"></script>
<script src="{{ js('bootstrap.bundle.min.js') }}"></script>
<script src="{{ js('iconify-icon.min.js') }}"></script>
<script src="{{ js('select2.min.js') }}"></script>
<script src="{{ js('jquery.basictable.min.js') }}"></script>
<script src="{{ js('gsap.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
<script src="{{ js('wow.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
<script src="{{ js('magnifc-popup.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
<script src="{{ js('TweenMax.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
<script src="{{ js('app.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>

@include('alert')

<script>
    'use strict';


    $('.responsive-table').basictable({
        breakpoint: 991,
    });

    function successToaster(message) {
        $.toast({
            text: message,
            showHideTransition: 'slide',
            bgColor: 'var(--success)',
            textColor: '#fff',
            allowToastClose: true,
            hideAfter: 5000,
            stack: 5,
            textAlign: 'left',
            position: 'top-right'
        })
    }

    function validationToaster(message) {
        $.toast({
            text: message,
            showHideTransition: 'slide',
            bgColor: 'var(--danger)',
            textColor: '#fff',
            allowToastClose: true,
            hideAfter: 5000,
            stack: 5,
            textAlign: 'left',
            position: 'top-right'
        })
    }


    function errorToaster(message) {
        $.toast({
            text: message,
            showHideTransition: 'slide',
            bgColor: 'var(--danger)',
            textColor: '#fff',
            allowToastClose: true,
            hideAfter: 5000,
            stack: 5,
            textAlign: 'left',
            position: 'top-right'
        })
    }
</script>


@if (tc()->get('pusher_status'))
    <script src="{{ js('pusher.min.js') }}"></script>


    <script>
        'use strict';

        var pusher = new Pusher("{{ tc()->get('pusher_app_key') }}", {
            cluster: "{{ tc()->get('pusher_app_cluster') }}"
        });

        var channel = pusher.subscribe('notifications');

        channel.bind('user-notification', function(data) {
            @auth
            if (data.user_id == "{{ user()->id }}") {
                const alertPlaceholder = $('#liveAlertPlaceholder');
                const notificationHtml = `
                    <div class="single-push-notification">
                        <span class="single-push-icon">
                            <iconify-icon icon="ph:seal-check-fill"></iconify-icon>
                        </span>
                        <p class="single-push-details mb-0">${data.message}</p>
                        <button type="button" class="single-push-close" aria-label="Close"><i class="ri-close-line"></i></button>
                    </div>
                `;

                // Append notification
                const $toast = $(notificationHtml).appendTo(alertPlaceholder);

                // Automatically add hide class after 4 seconds, then remove it from DOM
                setTimeout(function() {
                    $toast.fadeOut(1000, function() {
                        $(this).remove();
                    });
                }, 4000);
            }
        @endauth
        });

        @auth
        var messageChannel = pusher.subscribe(`message-notification`);
        messageChannel.bind('user-message', function(data) {
            if (data.message) {
                if (data.message.receiver_id == "{{ user()->id }}") {

                    if ("{{ route('messages') }}" != "{{ request()->url() }}") {
                        const audio = new Audio("{{ getTone() }}");

                        audio.play()
                            .then(() => true)
                            .catch((error) => console.error('Error playing sound:', error));
                    }

                    $.ajax({
                        url: "{{ route('message.old') }}",
                        type: "GET",
                        data: {
                            user_one: data.message.receiver_id,
                            user_two: data.message.data.sender_id
                        },
                        success: function(response) {
                            if (response.status === 'success') {
                                $(".message-chat-wrapper-header").html(`${response.data.header}`);
                                $(".message-chat-wrapper-body").html(`${response.data.body}`);
                                $(".message-sender-wrapper").html(`${response.data.sidebar}`);

                                var chatWrapper = document.querySelector('.message-chat-wrapper-body');

                                if (chatWrapper) {
                                    setTimeout(() => {
                                        var lastMessage = chatWrapper.querySelector(
                                            '.single-chat-message:last-child');
                                        if (lastMessage) {
                                            var lastMessageHeight = lastMessage.offsetTop +
                                                lastMessage
                                                .offsetHeight;
                                            chatWrapper.scrollTop = chatWrapper.scrollHeight;
                                        }
                                    }, 300);
                                }




                            }
                        },
                        error: function(xhr) {
                            console.error('Error:', xhr.responseJSON.message ||
                                'An error occurred.');
                        }
                    })
                }
            }
        });
        @endauth
    </script>
@endif

@if (tc()->get('tdio_status'))
    <script src="{{ tc()->get('tdio_url') }}" async></script>
@endif


@if (tc()->get('analytics_status'))
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ tc()->get('analytics_id') }}"></script>

    <script>
        'use strict'

        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', "{{ tc()->get('analytics_id') }}");
    </script>
@endif


<script>
    'use strict'


    function sendHttpRequest(method, url, data, locationIdOrHref, isRedirect = false) {
        $.ajax({
            method: method,
            url: url,
            data: data,
            success: function(response) {

                if (isRedirect) {
                    window.location.href = locationIdOrHref
                } else {
                    $(locationIdOrHref).html(response)
                }
            }
        })
    }


    $(".it-preloader").delay(300).animate({
        "opacity": "0"
    }, 300, function() {
        $(".it-preloader").css("display", "none");
    });



    $('.form-select-two').select2({
        placeholder: 'Select an option'
    });

    function validateEmail(email) {
        var re =
            /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    $(".form-select-two-tokenizer").select2({
        tags: true,
        tokenSeparators: [',', ' '],
        createTag: function(term, data) {
            var value = term.term;
            if (validateEmail(value)) {
                return {
                    id: value,
                    text: value
                };
            }
            return null;
        }
    })



    $('.accept').on('click', function() {
        document.cookie = "cookie_consent=accepted;path=/";
        document.getElementById('cookieConsentBanner').style.display = 'none';
    })

    $('.reject').on('click', function() {
        document.cookie = "cookie_consent=rejected;path=/";
        document.getElementById('cookieConsentBanner').style.display = 'none';
    })

    $(document).on('submit', '#subscribe', function(e) {
        e.preventDefault();
        const email = $('.email').val();
        var url = "{{ route('subscribe') }}";
        $.ajax({
            type: 'POST',
            url: url,
            data: {
                email: email,
                _token: "{{ csrf_token() }}"
            },
            success: (response) => {

                $('.email').val('')

                if (response.status) {
                    successToaster(response.message)
                } else {
                    errorToaster(response.message)
                }
            },
            error: function(response) {
                $('.email').val('')
                validationToaster(response.responseJSON.message)

            }
        })
    })
</script>


@stack('script')
