<footer class="it-footer">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-4">
                <div class="it-footer-card">
                    <img src="{{ getFile('logo', $themeSettings->dark_logo) }}" alt="image" class="it-footer-logo">
                    <h6 class="title mt-4">{{ cms('footer', 'title') }}</h6>
                    <p>{{ cms('footer', 'short_description') }}</p>
                    <form class="it-subscribe-form" id="subscribe">
                        <input type="email" name="email" required placeholder="{{ tt_front('Enter Your Email') }}"
                            class="form-control email">
                        <button type="submit" class="btn btn-primary-gradient">{{ tt_front('Subscribe') }}</button>
                    </form>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="it-footer-card">
                    <div class="row gy-4">
                        <?= footerMenuBuilder() ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="it-footer-bottom-card">
            <div class="row gy-2">
                <div class="col-lg-4 col-md-6 text-md-start text-center">
                    <p class="mb-0">{{ tt_front(tc()->get('copyright')) }}</p>
                </div>
                <div class="col-lg-4 col-md-6">
                    <ul
                        class="d-flex align-items-center justify-content-lg-center justify-content-md-end justify-content-center gap-3">

                        @foreach (cms('social', type: cons()::ELEMENT) as $elem)
                            <li><a href="{{ cms(key: 'link', id: $elem->id) }}" target="_blank"
                                    aria-label="Social Link"><?= $elem->content->icon ?></a></li>
                        @endforeach
                    </ul>
                </div>
                <div class="col-lg-4">
                    <ul class="it-inline-menu justify-content-lg-end justify-content-md-start justify-content-center">

                        @foreach (authMenus() as $menu)
                            <li>
                                <a href="{{ route('page', $menu->page->slug) }}">{{ $menu->page->name }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'middle-shade.png') }}" alt="image" class="it-footer-bottom-el">
    <img src="{{ getFile('constant_image', 'footer-left.png') }}" alt="image" class="it-footer-left-el">
    <img src="{{ getFile('constant_image', 'footer-right.png') }}" alt="image" class="it-footer-right-el">
</footer>
