<header class="it-header">
    <div class="container">
        <div class="row align-items-center justify-content-between">
            <div class="col-auto">
                <a href="{{ route('home') }}">
                    <img src="{{ getFile('logo', $themeSettings->logo) }}" alt="image" class="it-header-logo">
                </a>
            </div>
            <div class="col-auto">
                <div class="it-header-nav-wrapper">
                    <div class="it-header-nav-top">
                        <h6 class="mb-0">{{ tt_front('Menu') }}</h6>
                        <button type="submit" class="it-header-close-btn"><i class="bi bi-x-lg"></i></button>
                    </div>
                    <ul class="it-header-nav">
                        <li class="nav-item">
                            <a href="{{ route('home') }}"
                                class="nav-link {{ menuActive('home') }}">{{ tt_front('Home') }}</a>
                        </li>
                        @foreach (menus() as $menu)
                            <li class="nav-item">
                                <a href="{{ route('page', $menu->page->slug) }}"
                                    class="nav-link {{ menuActive($menu->page->slug) }}">{{ tt_front($menu->name) }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-auto">
                <div class="d-flex flex-wrap align-items-center gap-3">
                    <button type="submit" class="it-header-open-btn d-xl-none text-xl"><i
                            class="bi bi-justify"></i></button>
                    <div class="dropdown">
                        <button class="d-inline-flex align-items-center gap-1" type="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <span class="text-xl text-hover-primary line-height-1"><i class="bi bi-globe2"></i></span>
                            <span class="text-md line-height-1">{{ selectedLanguage()['code'] }}</span>
                        </button>
                        <ul class="dropdown-menu language-dropdown-menu">
                            <li>
                                <a class="dropdown-item {{ currentLanguage('en') }} d-flex align-items-center gap-2"
                                    href="{{ route('language-switch', 'en') }}">
                                    <img src="{{ getFile('common', 'en.png') }}" alt="language image"
                                        class="avatar-xs rounded-circle">
                                    {{ tt_front('en') }}
                                </a>
                            </li>
                            @foreach (languages() as $lang)
                                <li>
                                    <a class="dropdown-item d-flex {{ currentLanguage($lang->code) }} align-items-center gap-2"
                                        href="{{ route('language-switch', $lang->code) }}">
                                        <img src="{{ getFile('language', $lang->image) }}" alt="language image"
                                            class="avatar-xs rounded-circle">
                                        {{ tt_front($lang->name) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div>
                        <div class="dropdown d-xl-none">
                            <button type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="body-color text-xl"><i class="bi bi-person-circle"></i></span>
                            </button>
                            <ul class="dropdown-menu">
                                @auth
                                    <li><a href="{{ route('dashboard') }}" class="register-link dropdown-item">{{ tt_front('Dashboard') }}</a></li>
                                @else
                                    <li><a class="dropdown-item" href="{{ route('login') }}">{{ tt_front('Login') }}</a>
                                    </li>
                                    <li><a class="dropdown-item" href="{{ route('registration') }}">{{ tt_front('Registration') }}</a></li>
                                @endauth
                            </ul>
                        </div>
                        <div class="it-header-auth-link-btn">
                            @auth
                                <a href="{{ route('dashboard') }}" class="login-link">
                                    {{ tt_front('Dashboard') }}
                                    <i class="bi bi-arrow-up-right"></i>
                                </a>
                            @else
                                <a href="{{ route('registration') }}"
                                    class="register-link">{{ tt_front('Get Started') }}</a>
                                <a href="{{ route('login') }}" class="login-link">
                                    {{ tt_front('Login') }}
                                    <i class="bi bi-arrow-up-right"></i>
                                </a>
                            @endauth
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
