<div class="user-navbar">
    <button type="button" class="user-sidebar-open-btn">
        <i class="ri-bar-chart-horizontal-line"></i>
    </button>

    <div class="user-navbar-right d-flex flex-wrap align-items-center justify-content-between gap-3">
        <div class="d-flex flex-wrap align-items-center gap-3">
            <div class="dropdown">
                <button class="d-inline-flex flex-wrap align-items-center gap-2 nav-company-profile" type="button"
                    data-bs-toggle="dropdown">
                    <img src="{{ getFile('user', user()->image) }}" alt="image" class="avatar-lg rounded-circle">
                    <span class="d-sm-block d-none text-sm line-height-1">
                        <b>{{ user()->fullname }}</b>
                        <span class="d-flex align-items-center gap-1 line-height-1 text-xs text-muted mt-1">
                            {{ user()->email }}
                            <i class="ri-arrow-down-s-line"></i>
                        </span>
                    </span>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-2" href="{{ route('profile') }}">
                            <iconify-icon icon="hugeicons:user-circle-02"></iconify-icon>
                            {{ tt_front('Profile') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-2" href="{{ route('support.index') }}">
                            <iconify-icon icon="solar:settings-linear"></iconify-icon>
                            {{ tt_front('Support') }}
                        </a>
                    </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center gap-2" href="{{ route('logout') }}">
                            <iconify-icon icon="ant-design:logout-outlined"></iconify-icon>
                            {{ tt_front('Logout') }}
                        </a>
                    </li>
                </ul>
            </div>

        </div>

        <div class="d-flex flex-wrap align-items-center gap-2">
            <a href="{{ route('home') }}" class="action-icon rounded-circle" data-bs-toggle="tooltip"
                data-bs-title="{{ tt_front('Visit Home Page') }}" target="_blank">
                <iconify-icon icon="carbon:home" class="text-primary-light text-xl"></iconify-icon>
            </a>
            <div class="dropdown">
                <button class="action-icon rounded-circle" type="button" data-bs-toggle="dropdown"
                    data-bs-auto-close="outside">
                    <iconify-icon icon="iconoir:bell" class="text-primary-light text-xl"></iconify-icon>
                </button>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                    <div class="px-3 pt-2 pb-3 border-bottom">
                        <h6 class="text-md mb-0">{{ tt_front('Notifications') }}</h6>
                    </div>

                    <ul class="max-h-300">
                        @forelse (user()->unreadNotifications as $noti)
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-3 py-3"
                                    href="{{ $noti->data['url'] ?? '' }}">
                                    <span
                                        class="card-icon flex-shrink-0 bg-primary text-white rounded-circle d-flex justify-content-center align-items-center text-xl">
                                        <iconify-icon icon="solar:wallet-linear"></iconify-icon>
                                    </span>
                                    <span
                                        class="d-block flex-grow-1 display-color flex-grow-1 text-line-1 line-height-1">
                                        {{ tt_front($noti->data['message']) }}
                                        <br>
                                        <span
                                            class="d-block mt-2 body-color text-xs">{{ dateFormatter($noti->created_at) }}</span>
                                    </span>
                                </a>
                            </li>
                        @empty
                            <div class="no-data-wrapper text-center p-4">
                                <img src="{{ getFile('constant_image', 'no-data-found.png') }}" alt="image"
                                    class="no-data-img">
                                <h6 class="mt-4 mb-0 text-md">
                                    {{ tt_front("Haven't any notification yet") }}
                                </h6>
                            </div>
                        @endforelse
                    </ul>

                    <div class="d-flex align-items-center justify-content-between gap-3 px-3 pt-2 border-top">
                        <a href="{{ route('mark-as-all-read') }}" class="text-sm text-primary"><i
                                class="ri-check-double-line"></i>
                            {{ tt_front('Mark
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                all as read') }}</a>
                        <a href="{{ route('notification') }}"
                            class="btn btn-sm btn-light-primary">{{ tt_front('View All') }} <i
                                class="ri-arrow-right-line"></i></a>
                    </div>
                </div>
            </div>
            <div class="dropdown line-height-1">
                <button class="action-icon rounded-circle" type="button" data-bs-toggle="dropdown">
                    <iconify-icon icon="iconoir:language" class="text-primary-light text-xl"></iconify-icon>
                </button>
                <ul class="dropdown-menu language-dropdown-menu">
                    <li>
                        <a class="dropdown-item {{ currentLanguage('en') }} d-flex align-items-center gap-2"
                            href="{{ route('language-switch', 'en') }}">
                            <img src="{{ getFile('common', 'en.png') }}" alt="language image"
                                class="avatar-xs rounded-circle">
                            {{ tt_front('English') }}
                        </a>
                    </li>
                    @foreach (languages() as $lang)
                        <li>
                            <a class="dropdown-item {{ currentLanguage($lang->code) }} d-flex align-items-center gap-2"
                                href="{{ route('language-switch', $lang->code) }}">
                                <img src="{{ getFile('language', $lang->image) }}" alt="language image"
                                    class="avatar-xs rounded-circle">
                                {{ tt_front($lang->name) }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
            <a href="{{ route('deposit') }}" class="btn btn-sm btn-primary-gradient rounded-pill d-sm-inline-flex d-none align-items-center gap-1">
                <i class="bi bi-plus-circle"></i>
                {{ tt_front('Deposit') }}
            </a>
        </div>
    </div>
</div>



<div class="it-mobile-bar">
    <ul>
        <li>
            <a href="{{ route('home') }}" class="active">
                <i class="ri-home-6-fill"></i>
                <span>{{ tt_front('Home') }}</span>
            </a>
        </li>
        <li>
            <a href="{{ route('stage.index') }}">
                <i class="ri-briefcase-line"></i>
                <span>{{ tt_front('Stage') }}</span>
            </a>
        </li>
        <li>
            <a href="{{ route('deposit') }}" class="rt-mobile-bar-main-item">
                <i class="ri-add-line"></i>
            </a>
        </li>
        <li>
            <a href="{{ route('auctions') }}">
                <i class="ri-stack-line"></i>
                <span>{{ tt_front('Auction') }}</span>
            </a>
        </li>
        <li>
            <a href="{{ route('profile') }}">
                <i class="ri-account-circle-fill"></i>
                <span>{{ tt_front('Account') }}</span>
            </a>
        </li>
    </ul>
</div>
