<section class="it-banner">
    <div class="container">
        <div class="row gy-5 align-items-center justify-content-between">
            <div class="col-lg-6 text-lg-start text-center">
                <div class="it-banner-top-title">{{ cms('banner', 'banner_top_title') }}</div>
                <h2 class="it-banner-title cursor-scale">{{ cms('banner', 'banner_title') }}</h2>
                <p class="it-banner-description">{{ cms('banner', 'banner_details') }}</p>
                <div
                    class="d-flex flex-wrap align-items-center justify-content-lg-start justify-content-center gap-3 mt-4">
                    <a href="{{ route('whitepaper.download') }}" class="btn btn-primary-gradient"><i
                            class="bi bi-download"></i>{{ tt_front('White Paper') }}</a>
                    <a href="{{ route('stage.index') }}" class="btn btn-outline-light">{{ tt_front('Buy Token') }}
                        <i class="bi bi-arrow-up-right"></i>
                    </a>
                </div>
            </div>
            <div class="col-xxl-5 col-lg-6">
                <div class="it-ico-box">
                    <img src="{{ getFile('constant_image', '3d-el-5.png') }}" alt="image"
                        class="it-ico-box-el it-ico-box-el-1">

                    <div class="it-ico-box-img">
                        <img src="{{ getFile('constant_image', 'bg-shape-3.png') }}" alt="image">
                    </div>
                    <h3 class="title">
                        <i class="bi bi-lightning-charge-fill"></i>
                        <span>{{ cms('banner', 'calculator_title') }}</span>
                    </h3>

                    <div class="it-ico-box-timer">
                        <div id="ico-timer"></div>
                    </div>
                    @if (getActiveStage()['stage'])
                        <div class="d-flex flex-wrap align-items-center justify-content-between mt-4">
                            <p class="mb-2 text-white">{{ getActiveStage()['stage']->title }} : {{tt_front('Bonus')}}
                                {{ getActiveStage()['stage']->bonus_token }}
                                {{ getActiveStage()['setting']->token_symbol }}</p>
                            <p class="mb-2 text-white">{{ getActiveStage()['stage']->purchaseToken() }} /
                                {{ getActiveStage()['stage']->token_issues }}</p>
                        </div>
                        <div class="ico-box-progress-area">
                            <span class="ico-box-progress-label"
                                style="left: {{ getActiveStage()['stage']->tokenSellPercentage() }}%">{{ getActiveStage()['stage']->tokenSellPercentage() }}%</span>
                            <div class="progress ico-box-progress" role="progressbar" aria-label="Example with label"
                                aria-valuenow="{{ getActiveStage()['stage']->tokenSellPercentage() }}"
                                aria-valuemin="0" aria-valuemax="100">
                                <div class="progress-bar bg-primary rounded-pill"
                                    style="width: {{ getActiveStage()['stage']->tokenSellPercentage() }}%"> </div>
                            </div>
                        </div>

                        <div class="token-currency-part">
                            <div class="d-flex align-items-center gap-2">
                                <span class="main-token-icon">
                                    <img src="{{ getFile('ico_icon', getActiveStage()['setting']->icon) }}" alt="image">
                                </span>
                                <p class="mb-0">1 {{ getActiveStage()['setting']->token_symbol }} =
                                    <span class="exchange_currency">{{ getActiveStage()['stage']->exchangeRate(getActiveStage()['setting']->currency) }}
                                        {{ getActiveStage()['setting']->currency->name }}</span>
                                </p>
                            </div>

                            <div class="currency-dropdown dropdown">
                                <button type="button" class="currency-dropdown-btn"
                                    data-converter-id="{{ getActiveStage()['setting']['currency_id'] }}"
                                    data-bs-toggle="dropdown">
                                    <img src="{{ getFile('currency', getActiveStage()['setting']->currency->icon) }}"
                                        alt="image">
                                    <span>{{ tt_front('Buy on ') }}
                                        {{ getActiveStage()['setting']->currency->name }}</span>
                                    <i class="ri-arrow-down-s-line"></i>
                                </button>
                                <ul class="dropdown-menu scroll-y">

                                    @foreach (getActiveStage()['currencies'] as $currency)
                                        <li class="dropdown-item currency-option"
                                            data-currency="{{ json_encode($currency) }}">
                                            <img src="{{ getFile('currency', $currency->icon) }}" alt="image">
                                            <span>{{ $currency->name }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <div class="row gy-3 mt-2">
                            <div class="col-sm-6">
                                <p class="mb-2">{{ tt_front('Pay ') }} <span class="pay_currency_name">
                                        (
                                        {{ getActiveStage()['setting']->currency->name }} )</span></p>
                                <input type="number" step="any" readonly name="pay_amount" class="form-control"
                                    value="{{ getActiveStage()['stage']->exchangeRate(getActiveStage()['setting']->currency) }}">
                            </div>
                            <div class="col-sm-6">
                                <p class="mb-2">{{ tt_front('Get Token ') }}
                                    ({{ getActiveStage()['setting']->token_symbol }})</p>
                                <input type="number" name="get_token" value="1" class="form-control">
                            </div>
                        </div>
                        @if (getActiveStage()['stage']->status == cons()::ACTIVE)
                            <a href="{{ route('stage.buy', getActiveStage()['stage']->id) }}"
                                class="btn btn-primary-gradient w-100 rounded-pill mt-4">{{ tt_front('Buy Now') }} <i
                                    class="bi bi-arrow-up-right"></i></a>
                        @endif

                    @else
                        <div class="it-no-ico-box">
                            <div class="it-no-ico-box-inner">
                                <div class="icon">
                                    <iconify-icon icon="svg-spinners:clock"></iconify-icon>
                                </div>
                                <h6 class="text-sm text-center mt-3 mb-0">{{ tt_front('No Stage available') }}</h6>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <img src="{{ getFile('constant_image', 'bg-shape-1.png') }}" alt="image"
        class="it-banner-el it-banner-left-shade">
    <img src="{{ getFile('constant_image', 'bg-shape-2.png') }}" alt="image"
        class="it-banner-el it-banner-right-shade">
    <img src="{{ getFile('constant_image', 'shape-left.png') }}" alt="image"
        class="it-banner-el it-banner-left-shape">
    <img src="{{ getFile('constant_image', 'shape-right.png') }}" alt="image"
        class="it-banner-el it-banner-right-shape">

    <img src="{{ getFile('constant_image', 'left-star.png') }}" alt="image"
        class="it-banner-el it-banner-left-star">
    <img src="{{ getFile('constant_image', 'right-star.png') }}" alt="image"
        class="it-banner-el it-banner-right-star">
</section>

@push('script')
    <script src="{{ js('jquery.countdown.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    <script>
        $(function() {
            'use strict'

            @if (getActiveStage()['stage'])

                let end = "{{ dateFormatter(getActiveStage()['stage']->end_date, 'Y/m/d h:i:s') }}";

                $('#ico-timer').countdown(end, function(event) {
                    $(this).html(event.strftime('' +
                        '<div class="single-time"><div class="single-time-inner"><span>%D</span> <p>D</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%H</span> <p>H</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%M</span> <p>M</p></div></div>' +
                        '<div class="single-time"><div class="single-time-inner"><span>%S</span> <p>S</p></div></div>'
                        ));
                });
            @endif


            let converterInfo = {
                convert_currency_id: $('.currency-dropdown-btn').data('converter-id'),
                get_token: $('input[name="get_token"]').val() ?? 0
            }

            $('.currency-option').on('click', function() {
                let currency = $(this).data('currency');
                converterInfo.convert_currency_id = currency.id;
                calculateToken(converterInfo);
            });

            $("input[name=get_token]").on('input', function() {
                let val = $(this).val();
                converterInfo.get_token = val;
                calculateToken(converterInfo);
            });


            function calculateToken(data) {
                $.ajax({
                    url: "{{ route('stage.calculate') }}",
                    method: 'get',
                    data: data,
                    success: function(response) {
                        if (response.status) {

                            $('.currency-dropdown-btn').replaceWith(response.selected_option);
                            $('.exchange_currency').text(
                                `${response.base_price} ${response.currency_symbol}`);
                            $("input[name='pay_amount']").val(response.pay_amount);
                            $(".pay_currency_name").text(`( ${response.currency_symbol} )`);

                        }
                    }
                })
            }

        })
    </script>
@endpush
