<section class="it-brand">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h6 class="it-brand-title fw-semibold text-center">{{ cms('brand', 'brand_title') }}</h6>
            </div>
        </div>

        <div class="row gy-3 align-items-center">
            <div class="col-lg-12">
                <div class="it-brand-slider">
                    @foreach (cms('brand', '', cons()::ELEMENT) as $brand)
                        <div class="it-brand-slide">
                            <div class="it-brand-item">
                                <img src="{{ getFile('cms', $brand->content->image) }}" alt="image">
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

@once('slick_css')
    @push('style')
        <link rel="stylesheet" href="{{ css('slick.css', cons()::ASSETS_FROM_FRONTEND) }}">
    @endpush
@endonce

@push('script')
    @once('slick_js') <script src="{{ js('slick.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
        <script src="{{ js('slick-animation.min.js', cons()::ASSETS_FROM_FRONTEND) }}"></script>
    @endonce

    <script>
        'use strict'

        $(function() {

            $('.it-brand-slider').slick({
                dots: false,
                infinite: true,
                slidesToShow: 7,
                slidesToScroll: 2,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 0,
                speed: 8000,
                pauseOnHover: false,
                cssEase: 'linear',
                responsive: [{
                        breakpoint: 1400,
                        settings: {
                            slidesToShow: 5
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 4
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 3
                        }
                    }
                ]
            });

        });
    </script>
@endpush
